/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.log.PreFormatter;
import com.jcabi.log.SupplierLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.logging.Level;
import org.slf4j.LoggerFactory;

public final class Logger {
    private static final Object[] EMPTY = new Object[0];
    private static final String UTF_8 = "UTF-8";

    private Logger() {
    }

    public static String format(String fmt, Object ... args2) {
        String result;
        if (args2.length == 0) {
            result = fmt;
        } else {
            PreFormatter pre = new PreFormatter(fmt, args2);
            result = String.format(pre.getFormat(), pre.getArguments());
        }
        return result;
    }

    public static void trace(Object source2, String msg) {
        Logger.trace(source2, msg, EMPTY);
    }

    public static void trace(Object source2, String msg, Object ... args2) {
        if (Logger.isTraceEnabled(source2)) {
            Logger.traceForced(source2, msg, args2);
        }
    }

    public static void traceForced(Object source2, String msg, Object ... args2) {
        Logger.logger(source2).trace(Logger.format(msg, args2));
    }

    public static void debug(Object source2, String msg) {
        Logger.debug(source2, msg, EMPTY);
    }

    public static void debug(Object source2, String msg, Object ... args2) {
        if (Logger.isDebugEnabled(source2)) {
            Logger.debugForced(source2, msg, args2);
        }
    }

    public static void debugForced(Object source2, String msg, Object ... args2) {
        Logger.logger(source2).debug(Logger.format(msg, args2));
    }

    public static void info(Object source2, String msg) {
        Logger.info(source2, msg, EMPTY);
    }

    public static void info(Object source2, String msg, Object ... args2) {
        if (Logger.isInfoEnabled(source2)) {
            Logger.infoForced(source2, msg, args2);
        }
    }

    public static void infoForced(Object source2, String msg, Object ... args2) {
        Logger.logger(source2).info(Logger.format(msg, args2));
    }

    public static void warn(Object source2, String msg) {
        Logger.warn(source2, msg, EMPTY);
    }

    public static void warn(Object source2, String msg, Object ... args2) {
        if (Logger.isWarnEnabled(source2)) {
            Logger.warnForced(source2, msg, args2);
        }
    }

    public static void warnForced(Object source2, String msg, Object ... args2) {
        Logger.logger(source2).warn(Logger.format(msg, args2));
    }

    public static void error(Object source2, String msg) {
        Logger.error(source2, msg, EMPTY);
    }

    public static void error(Object source2, String msg, Object ... args2) {
        Logger.logger(source2).error(Logger.format(msg, args2));
    }

    public static boolean isTraceEnabled(Object source2) {
        return Logger.logger(source2).isTraceEnabled();
    }

    public static boolean isDebugEnabled(Object source2) {
        return Logger.logger(source2).isDebugEnabled();
    }

    public static boolean isInfoEnabled(Object source2) {
        return Logger.logger(source2).isInfoEnabled();
    }

    public static boolean isWarnEnabled(Object source2) {
        return Logger.logger(source2).isWarnEnabled();
    }

    public static boolean isEnabled(Level level, Object source2) {
        boolean enabled = false;
        if (level.equals(Level.SEVERE)) {
            enabled = Logger.logger(source2).isErrorEnabled();
        } else if (level.equals(Level.WARNING)) {
            enabled = Logger.logger(source2).isWarnEnabled();
        } else if (level.equals(Level.INFO) || level.equals(Level.CONFIG)) {
            enabled = Logger.logger(source2).isInfoEnabled();
        } else if (level.equals(Level.FINE) || level.equals(Level.ALL)) {
            enabled = Logger.logger(source2).isDebugEnabled();
        } else if (level.equals(Level.FINER) || level.equals(Level.FINEST)) {
            enabled = Logger.logger(source2).isTraceEnabled();
        }
        return enabled;
    }

    public static void log(Level level, Object source2, String msg, Object ... args2) {
        if (level.equals(Level.SEVERE)) {
            Logger.error(source2, msg, args2);
        } else if (level.equals(Level.WARNING)) {
            Logger.warn(source2, msg, args2);
        } else if (level.equals(Level.INFO) || level.equals(Level.CONFIG)) {
            Logger.info(source2, msg, args2);
        } else if (level.equals(Level.FINE) || level.equals(Level.ALL)) {
            Logger.debug(source2, msg, args2);
        } else if (level.equals(Level.FINER) || level.equals(Level.FINEST)) {
            Logger.trace(source2, msg, args2);
        }
    }

    public static OutputStream stream(final Level level, final Object source2) {
        return new OutputStream(){
            private final transient ByteArrayOutputStream buffer = new ByteArrayOutputStream();

            @Override
            public void write(int data) throws IOException {
                if (data == 10) {
                    Logger.log(level, source2, this.buffer.toString(Logger.UTF_8), new Object[0]);
                    this.buffer.reset();
                } else if (data >= 32 && data <= 127) {
                    this.buffer.write(data);
                } else {
                    this.buffer.write(String.format("\\x%02x", data & 0xFF).getBytes(Logger.UTF_8));
                }
            }
        };
    }

    public static SupplierLogger withSupplier() {
        return new SupplierLogger();
    }

    private static void setFinalStatic(Field field, Object value) throws NoSuchFieldException, IllegalAccessException {
        field.setAccessible(true);
        Field modifiers = Field.class.getDeclaredField("modifiers");
        modifiers.setAccessible(true);
        modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, value);
    }

    private static org.slf4j.Logger logger(Object source2) {
        org.slf4j.Logger logger = source2 instanceof Class ? LoggerFactory.getLogger((Class)source2) : (source2 instanceof String ? LoggerFactory.getLogger((String)String.class.cast(source2)) : LoggerFactory.getLogger(source2.getClass()));
        if ("org.slf4j.impl.Log4jLoggerAdapter".equals(logger.getClass().getName())) {
            try {
                Field fqcn = logger.getClass().getDeclaredField("FQCN");
                Logger.setFinalStatic(fqcn, Logger.class.getName());
            }
            catch (NoSuchFieldException ex) {
                throw new IllegalStateException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return logger;
    }
}

