/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.log.DecorException;
import com.jcabi.log.DecorsManager;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PreFormatter {
    private static final Pattern PATTERN = Pattern.compile("%(\\d+\\$)?(\\[([A-Za-z\\-\\.0-9]+)\\])?[\\+\\-]?(?:\\d*(?:\\.\\d+)?)?[a-zA-Z%]");
    private static final List<String> NO_ARG_SPECIFIERS = Arrays.asList("%n", "%%");
    private transient String format;
    private transient List<Object> arguments;

    PreFormatter(String fmt, Object ... args2) {
        this.process(fmt, args2);
    }

    public String getFormat() {
        return this.format;
    }

    public Object[] getArguments() {
        return this.arguments.toArray(new Object[this.arguments.size()]);
    }

    private void process(CharSequence fmt, Object ... args2) {
        this.arguments = new CopyOnWriteArrayList<Object>();
        StringBuffer buf = new StringBuffer(fmt.length());
        Matcher matcher = PATTERN.matcher(fmt);
        int pos = 0;
        while (matcher.find()) {
            String group = matcher.group();
            if (NO_ARG_SPECIFIERS.contains(group)) {
                matcher.appendReplacement(buf, Matcher.quoteReplacement(group));
                continue;
            }
            String decor = matcher.group(3);
            if (matcher.group(1) != null) {
                matcher.appendReplacement(buf, Matcher.quoteReplacement(group));
                --pos;
            } else if (decor == null) {
                matcher.appendReplacement(buf, Matcher.quoteReplacement(group));
                this.arguments.add(args2[pos]);
            } else {
                matcher.appendReplacement(buf, Matcher.quoteReplacement(group.replace(matcher.group(2), "")));
                try {
                    this.arguments.add(DecorsManager.decor(decor, args2[pos]));
                }
                catch (DecorException ex) {
                    this.arguments.add(String.format("[%s]", ex.getMessage()));
                }
            }
            ++pos;
        }
        if (pos < args2.length) {
            throw new IllegalArgumentException(String.format("There are %d parameter(s) but only %d format argument(s) were provided.", args2.length, pos));
        }
        matcher.appendTail(buf);
        this.format = buf.toString();
    }
}

