/*
 * Decompiled with CFR 0.152.
 */
package com.sprylab.xar;

import com.sprylab.xar.XarSource;
import com.sprylab.xar.utils.RandomAccessFileSource;
import java.io.File;
import java.io.IOException;
import okio.BufferedSource;
import okio.Okio;

public class FileXarSource
extends XarSource {
    private final File file;

    public FileXarSource(File file) {
        this.file = file;
    }

    @Override
    public BufferedSource getRange(long offset, long length) throws IOException {
        return Okio.buffer(new RandomAccessFileSource(this.file, offset, length));
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    public String toString() {
        return String.format("FileXarSource{file=%s}", this.file.getAbsolutePath());
    }

    public File getFile() {
        return this.file;
    }
}

