/*
 * Decompiled with CFR 0.152.
 */
package com.sprylab.xar;

import com.jcabi.manifests.Manifests;
import com.sprylab.xar.FileXarSource;
import com.sprylab.xar.HttpXarSource;
import com.sprylab.xar.XarEntry;
import com.sprylab.xar.XarException;
import com.sprylab.xar.XarHeader;
import com.sprylab.xar.XarSource;
import com.sprylab.xar.toc.TocFactory;
import com.sprylab.xar.toc.model.ChecksumAlgorithm;
import com.sprylab.xar.utils.StringUtils;
import com.sprylab.xar.writer.XarPacker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    private static final String V_OPTION = "v";
    private static final String C_OPTION = "c";
    private static final String X_OPTION = "x";
    private static final String T_OPTION = "t";
    private static final String F_OPTION = "f";
    private static final String FILENAME_OPTION = "filename";
    private static final String DUMP_TOC_OPTION = "dump-toc";
    private static final String DUMP_HEADER_OPTION = "dump-header";
    private static final String VERSION_OPTION = "version";
    private static final String USAGE = "java -jar xar -[tx][v] -f <archive> ...";
    private static final String VERSION_MANIFEST_KEY = "Version";

    public static void main(String[] args2) {
        Options options = Main.createCommandLineOptions();
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine line = parser.parse(options, args2);
            if (line.hasOption(F_OPTION)) {
                String fileOrUrl = line.getOptionValue(F_OPTION);
                List<String> argList = line.getArgList();
                if (line.hasOption(C_OPTION)) {
                    File archiveFile = new File(fileOrUrl);
                    XarPacker packer = new XarPacker(archiveFile);
                    for (String additionalArgument : argList) {
                        File fileToAdd = new File(additionalArgument);
                        if (!fileToAdd.isDirectory()) continue;
                        try {
                            packer.addDirectory(fileToAdd, false, null);
                        }
                        catch (Exception e) {
                            LOG.error("Cannot add {} as it's not a directory.", (Object)fileToAdd.getAbsolutePath(), (Object)e);
                        }
                    }
                    packer.write();
                } else {
                    XarSource xarSource = StringUtils.isNotEmpty(fileOrUrl) && fileOrUrl.startsWith("http") ? new HttpXarSource(fileOrUrl) : new FileXarSource(new File(fileOrUrl));
                    if (line.hasOption(X_OPTION)) {
                        File destination = argList == null || argList.isEmpty() ? new File(Main.getWorkingDir()) : new File(argList.get(0));
                        XarSource.DEBUG = line.hasOption(V_OPTION);
                        Main.extractFiles(xarSource, destination);
                    } else if (line.hasOption(T_OPTION)) {
                        Main.listEntries(xarSource);
                    } else if (line.hasOption(DUMP_HEADER_OPTION)) {
                        Main.dumpHeader(xarSource);
                    } else if (line.hasOption(DUMP_TOC_OPTION)) {
                        File tocFile = new File(line.getOptionValue(DUMP_TOC_OPTION));
                        Main.dumpToC(xarSource, tocFile);
                    } else {
                        Main.printHelp(options);
                    }
                }
            } else if (line.hasOption(VERSION_OPTION)) {
                Main.printVersion();
            } else {
                Main.printHelp(options);
            }
        }
        catch (ParseException e) {
            Main.printHelp(options);
            LOG.error("Parsing commandline failed.", e);
        }
        catch (IOException e) {
            LOG.error("Opening xar file failed.", e);
        }
        catch (Exception e) {
            LOG.error("Unknown error.", e);
        }
    }

    private static String getWorkingDir() {
        return System.getProperty("user.dir");
    }

    private static void extractFiles(XarSource xarSource, File destinationDir) throws IOException {
        xarSource.extractAll(destinationDir, false);
    }

    private static void listEntries(XarSource xarSource) throws XarException {
        List<XarEntry> entries = xarSource.getEntries();
        for (XarEntry entry : entries) {
            LOG.info(entry.toString());
        }
    }

    private static void dumpHeader(XarSource xarSource) throws XarException {
        XarHeader header = xarSource.getHeader();
        String headerStatus = header.hasValidMagic() ? "OK" : "INVALID";
        LOG.info("magic:                   {} ({})", (Object)String.format("%#x", header.getMagic().intValue()), (Object)headerStatus);
        LOG.info("size:                    {}", (Object)header.getSize());
        LOG.info("version:                 {}", (Object)header.getVersion());
        LOG.info("Compressed TOC length:   {}", (Object)header.getTocLengthCompressed());
        LOG.info("Uncompressed TOC length: {}", (Object)header.getTocLengthUncompressed());
        int cksumAlg = header.getCksumAlg().intValue();
        LOG.info("Checksum algorithm:      {} ({})", (Object)cksumAlg, (Object)ChecksumAlgorithm.values()[cksumAlg].toString().toLowerCase());
    }

    private static void dumpToC(XarSource xarSource, File tocFile) {
        try (InputStream toCStream = xarSource.getToCStream();
             FileOutputStream os = new FileOutputStream(tocFile);){
            TocFactory.copy(toCStream, os);
        }
        catch (Exception e) {
            LOG.error("Failed dumping header.", e);
        }
    }

    private static Options createCommandLineOptions() {
        Option create = new Option(C_OPTION, "Creates an archive");
        Option extract = new Option(X_OPTION, "Extracts an archive");
        Option list = new Option(T_OPTION, "Lists an archive");
        Option file = Option.builder(F_OPTION).hasArg().argName(FILENAME_OPTION).desc("Specifies an archive to operate on [REQUIRED!]").build();
        Option dumpToc = Option.builder().longOpt(DUMP_TOC_OPTION).hasArg().argName(FILENAME_OPTION).desc("Has xar dump the xml header into the specified file.").build();
        Option dumpHeader = Option.builder().longOpt(DUMP_HEADER_OPTION).desc("Prints out the xar binary header information").build();
        Option verbose = Option.builder(V_OPTION).desc("Print filenames as they are archived").build();
        Option version = Option.builder().longOpt(VERSION_OPTION).desc("Print xar's version number").build();
        Options options = new Options();
        options.addOption(create);
        options.addOption(extract);
        options.addOption(list);
        options.addOption(file);
        options.addOption(dumpToc);
        options.addOption(dumpHeader);
        options.addOption(verbose);
        options.addOption(version);
        return options;
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(USAGE, options);
    }

    private static void printVersion() {
        LOG.info("xar {}", (Object)Manifests.read(VERSION_MANIFEST_KEY));
        LOG.info("This is a port to pure Java.");
    }

    private Main() {
    }
}

