/*
 * Decompiled with CFR 0.152.
 */
package com.sprylab.xar;

import com.sprylab.xar.XarException;
import com.sprylab.xar.XarHeader;
import com.sprylab.xar.XarSource;
import com.sprylab.xar.toc.model.ChecksumAlgorithm;
import com.sprylab.xar.toc.model.Data;
import com.sprylab.xar.toc.model.Encoding;
import com.sprylab.xar.toc.model.File;
import com.sprylab.xar.toc.model.SimpleChecksum;
import com.sprylab.xar.toc.model.Type;
import com.sprylab.xar.utils.HashUtils;
import com.sprylab.xar.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.Inflater;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.InflaterSource;
import okio.Okio;
import okio.Source;

public class XarEntry {
    private String id;
    private String name;
    private boolean isDirectory;
    private List<XarEntry> children;
    private String mode;
    private String uid;
    private String user;
    private String gid;
    private String group;
    private Date time;
    private ChecksumAlgorithm checksumAlgorithm;
    private String checksum;
    private long size;
    private long offset;
    private long length;
    private Encoding encoding;
    private XarSource xarSource;

    public static XarEntry createFromXarSource(XarSource xarSource, File file, String parentPath) throws XarException {
        XarEntry xarEntry = new XarEntry();
        xarEntry.id = file.getId();
        String name = file.getName();
        if (StringUtils.isNotEmpty(parentPath)) {
            name = parentPath + "/" + name;
        }
        xarEntry.name = name;
        xarEntry.isDirectory = file.getType() == Type.DIRECTORY;
        xarEntry.mode = file.getMode();
        xarEntry.uid = file.getUid();
        xarEntry.user = file.getUser();
        xarEntry.gid = file.getGid();
        xarEntry.group = file.getGroup();
        xarEntry.time = file.getMtime();
        xarEntry.xarSource = xarSource;
        Data data = file.getData();
        if (data != null) {
            SimpleChecksum extractedChecksum = null;
            if (data.getExtractedChecksum() != null) {
                extractedChecksum = data.getExtractedChecksum();
            } else if (data.getUnarchivedChecksum() != null) {
                extractedChecksum = data.getUnarchivedChecksum();
            }
            if (extractedChecksum != null) {
                xarEntry.checksumAlgorithm = extractedChecksum.getStyle();
                xarEntry.checksum = extractedChecksum.getValue();
            } else {
                xarEntry.checksumAlgorithm = ChecksumAlgorithm.NONE;
                xarEntry.checksum = null;
            }
            xarEntry.size = data.getSize();
            XarHeader header = xarSource.getHeader();
            xarEntry.offset = header.getSize().longValue() + header.getTocLengthCompressed().longValue() + data.getOffset();
            xarEntry.length = data.getLength();
            xarEntry.encoding = data.getEncoding();
        }
        return xarEntry;
    }

    private XarEntry() {
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public String getMode() {
        return this.mode;
    }

    public String getUid() {
        return this.uid;
    }

    public String getUser() {
        return this.user;
    }

    public String getGid() {
        return this.gid;
    }

    public String getGroup() {
        return this.group;
    }

    public Date getTime() {
        return this.time;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public ChecksumAlgorithm getChecksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    public long getSize() {
        return this.size;
    }

    public List<XarEntry> getChildren() {
        return this.children;
    }

    public void addChild(XarEntry childEntry) {
        if (this.children == null) {
            this.children = new ArrayList<XarEntry>();
        }
        this.children.add(childEntry);
    }

    public Source getSource() throws IOException {
        if (this.isDirectory) {
            throw new IllegalStateException("Cannot retrieve source for entries of type directory.");
        }
        if (this.encoding == null) {
            return new Buffer();
        }
        switch (this.encoding) {
            case NONE: {
                return this.xarSource.getRange(this.offset, this.length);
            }
            case GZIP: {
                return new InflaterSource(this.xarSource.getRange(this.offset, this.length), new Inflater());
            }
        }
        throw new UnsupportedEncodingException("Encoding not supported: " + this.encoding.name());
    }

    public Source getRawSource() throws IOException {
        if (this.isDirectory) {
            throw new IllegalStateException("Cannot retrieve source for entries of type directory.");
        }
        if (this.encoding == null) {
            return new Buffer();
        }
        return this.xarSource.getRange(this.offset, this.length);
    }

    public InputStream getInputStream() throws IOException {
        return Okio.buffer(this.getSource()).inputStream();
    }

    public byte[] getBytes() throws IOException {
        return Okio.buffer(this.getSource()).readByteArray();
    }

    public void extract(java.io.File fileOrDirectory) throws IOException {
        this.extract(fileOrDirectory, false);
    }

    public void extract(java.io.File fileOrDirectory, boolean verifyIntegrity) throws IOException {
        this.extract(fileOrDirectory, verifyIntegrity, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(java.io.File fileOrDirectory, boolean verifyIntegrity, XarSource.OnEntryExtractedListener listener) throws IOException {
        if (this.isDirectory) {
            List<XarEntry> entries = this.xarSource.getToc().getEntries();
            String directoryPath = this.name.concat("/");
            ArrayList<XarEntry> files = new ArrayList<XarEntry>();
            for (XarEntry entry : entries) {
                if (entry.getName().length() <= directoryPath.length() || !entry.getName().substring(0, directoryPath.length()).equals(directoryPath)) continue;
                files.add(entry);
            }
            for (XarEntry file : files) {
                file.extract(fileOrDirectory, verifyIntegrity, listener);
            }
        } else {
            java.io.File targetFile = fileOrDirectory.isFile() ? fileOrDirectory : new java.io.File(fileOrDirectory, this.name);
            targetFile.getParentFile().mkdirs();
            try (Source source2 = this.getSource();
                 BufferedSink sink2 = Okio.buffer(Okio.sink(targetFile));){
                sink2.writeAll(source2);
            }
            finally {
                if (verifyIntegrity) {
                    this.verifyExtractedFile(targetFile);
                }
                if (listener != null) {
                    listener.onEntryExtracted(this);
                }
            }
        }
    }

    private void verifyExtractedFile(java.io.File targetFile) throws IOException {
        if (this.checksumAlgorithm == null && this.size == 0L || this.checksumAlgorithm == ChecksumAlgorithm.NONE) {
            return;
        }
        try (BufferedSource source2 = Okio.buffer(Okio.source(targetFile));){
            source2.require(targetFile.length());
            String hash = HashUtils.hashHex(source2, this.checksumAlgorithm);
            if (!this.checksum.equals(hash)) {
                throw new IOException("Hash of extracted file does match the stored checksum.");
            }
        }
    }

    public String toString() {
        if (this.isDirectory) {
            return String.format("XarEntry{name='%s', children=%d}", this.name, this.children.size());
        }
        return String.format("XarEntry{name='%s', size=%d}", this.name, this.size);
    }
}

