/*
 * Decompiled with CFR 0.152.
 */
package com.sprylab.xar;

import com.sprylab.xar.XarException;
import com.sprylab.xar.XarSource;
import com.sprylab.xar.toc.model.ChecksumAlgorithm;
import java.io.IOException;
import java.nio.ByteBuffer;
import okio.BufferedSource;
import org.joou.UInteger;
import org.joou.ULong;
import org.joou.UShort;

public class XarHeader {
    private static final UInteger MAGIC = UInteger.valueOf(2019652129);
    private static final short HEADER_SIZE = 28;
    private static final short VERSION = 1;
    private final UInteger magic;
    private final UShort size;
    private final UShort version;
    private final ULong tocLengthCompressed;
    private final ULong tocLengthUncompressed;
    private final UInteger cksumAlg;

    public static byte[] createHeader(long tocLengthCompressed, long tocLengthUncompressed, ChecksumAlgorithm checksumAlgorithm) {
        ByteBuffer bb = ByteBuffer.allocate(28);
        bb.putInt(0, MAGIC.intValue());
        bb.putShort(4, (short)28);
        bb.putShort(6, (short)1);
        bb.putLong(8, tocLengthCompressed);
        bb.putLong(16, tocLengthUncompressed);
        bb.putInt(24, checksumAlgorithm.ordinal());
        return bb.array();
    }

    public XarHeader(XarSource xarSource) throws XarException {
        try (BufferedSource source2 = xarSource.getRange(0L, 28L);){
            this.magic = UInteger.valueOf(source2.readInt());
            this.checkMagic();
            this.size = UShort.valueOf(source2.readShort());
            this.version = UShort.valueOf(source2.readShort());
            this.tocLengthCompressed = ULong.valueOf(source2.readLong());
            this.tocLengthUncompressed = ULong.valueOf(source2.readLong());
            this.cksumAlg = UInteger.valueOf(source2.readInt());
        }
        catch (IOException e) {
            throw new XarException("Error reading header", e);
        }
    }

    private void checkMagic() {
        if (!this.hasValidMagic()) {
            this.throwNoValidHeaderError();
        }
    }

    private void throwNoValidHeaderError() {
        throw new IllegalArgumentException("No valid xar header found.");
    }

    public boolean hasValidMagic() {
        return this.magic.equals(MAGIC);
    }

    public UInteger getMagic() {
        return this.magic;
    }

    public UShort getSize() {
        return this.size;
    }

    public UShort getVersion() {
        return this.version;
    }

    public ULong getTocLengthCompressed() {
        return this.tocLengthCompressed;
    }

    public ULong getTocLengthUncompressed() {
        return this.tocLengthUncompressed;
    }

    public UInteger getCksumAlg() {
        return this.cksumAlg;
    }
}

