/*
 * Decompiled with CFR 0.152.
 */
package com.sprylab.xar;

import com.sprylab.xar.XarEntry;
import com.sprylab.xar.XarException;
import com.sprylab.xar.XarHeader;
import com.sprylab.xar.XarToc;
import com.sprylab.xar.XarTocParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.Inflater;
import okio.BufferedSource;
import okio.InflaterSource;
import okio.Okio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XarSource {
    private static final Logger LOG = LoggerFactory.getLogger(XarSource.class);
    static boolean DEBUG;
    public XarTocParser customParser;
    private XarHeader header;
    private XarToc toc;

    public XarHeader getHeader() throws XarException {
        this.ensureHeader();
        return this.header;
    }

    public XarToc getToc() throws XarException {
        this.ensureHeader();
        this.ensureToc();
        return this.toc;
    }

    public BufferedSource getToCSource() throws IOException {
        long headerSize = this.getHeader().getSize().longValue();
        long compressedTocSize = this.getHeader().getTocLengthCompressed().longValue();
        return Okio.buffer(new InflaterSource(this.getRange(headerSize, compressedTocSize), new Inflater()));
    }

    public InputStream getToCStream() throws IOException {
        return Okio.buffer(this.getToCSource()).inputStream();
    }

    public abstract BufferedSource getRange(long var1, long var3) throws IOException;

    public abstract long getSize() throws XarException;

    public List<XarEntry> getEntries() throws XarException {
        return this.getToc().getEntries();
    }

    public XarEntry getEntry(String entryName) throws XarException {
        return this.getToc().getEntry(entryName);
    }

    public boolean hasEntry(String entryName) throws XarException {
        return this.getToc().hasEntry(entryName);
    }

    public void extractAll(File directory) throws IOException {
        this.extractAll(directory, false);
    }

    public void extractAll(File directory, boolean verifyIntegrity) throws IOException {
        this.extractAll(directory, verifyIntegrity, null);
    }

    public void extractAll(File directory, boolean verifyIntegrity, OnEntryExtractedListener listener) throws IOException {
        List<XarEntry> entries = this.getToc().getEntries();
        int entriesSize = entries.size();
        for (int i = 0; i < entriesSize; ++i) {
            XarEntry entry = entries.get(i);
            if (entry.isDirectory()) continue;
            if (DEBUG) {
                LOG.debug("Extracting entry '{}'.", (Object)entry);
            }
            entry.extract(directory, verifyIntegrity, listener);
        }
    }

    private void ensureToc() throws XarException {
        if (this.toc == null) {
            this.toc = this.createToc();
        }
    }

    private void ensureHeader() throws XarException {
        if (this.header == null) {
            this.header = this.createHeader();
        }
    }

    private XarToc createToc() throws XarException {
        return new XarToc(this, this.customParser);
    }

    private XarHeader createHeader() throws XarException {
        return new XarHeader(this);
    }

    public static interface OnEntryExtractedListener {
        public void onEntryExtracted(XarEntry var1);
    }
}

