/*
 * Decompiled with CFR 0.152.
 */
package com.sprylab.xar;

import com.sprylab.xar.XarEntry;
import com.sprylab.xar.XarException;
import com.sprylab.xar.XarSource;
import com.sprylab.xar.XarTocParser;
import com.sprylab.xar.toc.TocFactory;
import com.sprylab.xar.toc.model.File;
import com.sprylab.xar.toc.model.ToC;
import com.sprylab.xar.utils.FilePath;
import com.sprylab.xar.utils.StringUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class XarToc {
    private final ToC model;
    private final List<XarEntry> entries = new ArrayList<XarEntry>();
    private final Map<String, XarEntry> nameToEntryMap = new HashMap<String, XarEntry>();
    private final XarSource xarSource;

    public XarToc(XarSource xarSource, XarTocParser parser) throws XarException {
        this.xarSource = xarSource;
        try (InputStream inputStream2 = xarSource.getToCStream();){
            this.model = parser != null ? parser.parse(inputStream2) : TocFactory.fromInputStream(inputStream2);
            this.createEntries();
        }
        catch (Exception e) {
            throw new XarException("Could not create toc", e);
        }
    }

    private void createEntries() throws XarException {
        Stack<FilePath> fileStack = new Stack<FilePath>();
        fileStack.addAll(FilePath.fromFileList(this.model.getFiles()));
        while (!fileStack.isEmpty()) {
            List<File> children;
            FilePath currentFile = (FilePath)fileStack.pop();
            File fileEntry = currentFile.getFile();
            XarEntry xarEntry = XarEntry.createFromXarSource(this.xarSource, fileEntry, currentFile.getParentPath());
            if (xarEntry.isDirectory() && (children = fileEntry.getChildren()) != null && !children.isEmpty()) {
                fileStack.addAll(FilePath.fromFileList(children, xarEntry.getName()));
            }
            this.addEntry(xarEntry);
            this.addToParentEntry(xarEntry, currentFile.getParentPath());
        }
    }

    private void addEntry(XarEntry xarEntry) {
        this.entries.add(xarEntry);
        this.nameToEntryMap.put(xarEntry.getName(), xarEntry);
    }

    private void addToParentEntry(XarEntry xarEntry, String parentPath) {
        if (StringUtils.isEmpty(parentPath)) {
            return;
        }
        XarEntry parentEntry = this.nameToEntryMap.get(parentPath);
        parentEntry.addChild(xarEntry);
    }

    public List<XarEntry> getEntries() {
        return this.entries;
    }

    public XarEntry getEntry(String entryName) {
        return this.nameToEntryMap.get(entryName);
    }

    public boolean hasEntry(String entryName) {
        return this.nameToEntryMap.containsKey(entryName);
    }
}

