/*
 * Decompiled with CFR 0.152.
 */
package com.sprylab.xar.toc;

import com.sprylab.xar.toc.model.ChecksumAlgorithm;
import com.sprylab.xar.toc.model.DateTransform;
import com.sprylab.xar.toc.model.Encoding;
import com.sprylab.xar.toc.model.EncodingEnumTransform;
import com.sprylab.xar.toc.model.LowerCaseEnumTransform;
import com.sprylab.xar.toc.model.ToC;
import com.sprylab.xar.toc.model.Type;
import com.sprylab.xar.toc.model.Xar;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.stream.HyphenStyle;
import org.simpleframework.xml.transform.RegistryMatcher;

public class TocFactory {
    private static Serializer createFactory() {
        HyphenStyle style = new HyphenStyle();
        Format format = new Format(style);
        RegistryMatcher matcher = new RegistryMatcher();
        matcher.bind(Date.class, DateTransform.class);
        matcher.bind(ChecksumAlgorithm.class, new LowerCaseEnumTransform(ChecksumAlgorithm.class));
        matcher.bind(Type.class, new LowerCaseEnumTransform(Type.class));
        matcher.bind(Encoding.class, new EncodingEnumTransform());
        return new Persister(matcher, format);
    }

    public static ToC fromInputStream(InputStream source2) throws Exception {
        Serializer serializer = TocFactory.createFactory();
        Xar xar = (Xar)((Object)serializer.read(Xar.class, source2, false));
        return xar.getToc();
    }

    public static void copy(InputStream source2, OutputStream target) throws Exception {
        Serializer serializer = TocFactory.createFactory();
        Xar xar = (Xar)((Object)serializer.read(Xar.class, source2, false));
        serializer.write((Object)xar, target);
    }

    public static void toOutputStream(ToC toc, OutputStream target) throws Exception {
        Xar xar = new Xar();
        xar.setToc(toc);
        Serializer serializer = TocFactory.createFactory();
        serializer.write((Object)xar, target);
    }
}

