/*
 * Decompiled with CFR 0.152.
 */
package com.sprylab.xar.utils;

import com.sprylab.xar.toc.model.ChecksumAlgorithm;
import okio.BufferedSource;
import okio.ByteString;

public final class HashUtils {
    private HashUtils() {
    }

    public static ByteString hash(BufferedSource source2, ChecksumAlgorithm algorithm) {
        switch (algorithm) {
            case NONE: {
                return null;
            }
            case SHA1: {
                return HashUtils.sha1(source2);
            }
            case MD5: {
                return HashUtils.md5(source2);
            }
        }
        throw new UnsupportedOperationException("Unsupported checksum algorithm " + algorithm.name());
    }

    public static String hashHex(BufferedSource source2, ChecksumAlgorithm algorithm) {
        if (algorithm == ChecksumAlgorithm.NONE) {
            return null;
        }
        return HashUtils.hash(source2, algorithm).hex();
    }

    public static ByteString sha1(BufferedSource source2) {
        return source2.buffer().sha1();
    }

    public static String sha1Hex(BufferedSource source2) {
        return HashUtils.sha1(source2).hex();
    }

    public static ByteString md5(BufferedSource source2) {
        return source2.buffer().md5();
    }

    public static String md5Hex(BufferedSource source2) {
        return HashUtils.md5(source2).hex();
    }
}

