/*
 * Decompiled with CFR 0.152.
 */
package com.sprylab.xar.utils;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import okio.Buffer;
import okio.Source;
import okio.Timeout;

public class RandomAccessFileSource
implements Source {
    private final RandomAccessFile randomAccessFile;
    private final Timeout timeout;
    private long remainingLength;

    public RandomAccessFileSource(File file) throws IOException {
        this(file, 0L, file.length());
    }

    public RandomAccessFileSource(File file, long offset, long length) throws IOException {
        this(file, offset, length, new Timeout());
    }

    public RandomAccessFileSource(File file, long offset, long length, Timeout timeout2) throws IOException {
        this.randomAccessFile = new RandomAccessFile(file, "r");
        this.randomAccessFile.seek(offset);
        this.remainingLength = length;
        this.timeout = timeout2;
    }

    @Override
    public long read(Buffer sink2, long byteCount) throws IOException {
        if (byteCount < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + byteCount);
        }
        if (byteCount == 0L) {
            return 0L;
        }
        if (this.remainingLength == 0L) {
            return -1L;
        }
        this.timeout.throwIfReached();
        int maxToCopy = (int)Math.min(byteCount, this.remainingLength);
        byte[] bytes = new byte[maxToCopy];
        int bytesRead = this.randomAccessFile.read(bytes, 0, maxToCopy);
        if (bytesRead == -1) {
            return -1L;
        }
        sink2.write(bytes);
        this.remainingLength -= (long)bytesRead;
        return bytesRead;
    }

    @Override
    public Timeout timeout() {
        return this.timeout;
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }
}

