/*
 * Decompiled with CFR 0.152.
 */
package com.sprylab.xar.writer;

import com.sprylab.xar.toc.model.ChecksumAlgorithm;
import com.sprylab.xar.toc.model.Encoding;
import com.sprylab.xar.utils.HashUtils;
import com.sprylab.xar.writer.XarEntrySource;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.Deflater;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.DeflaterSink;
import okio.Okio;
import okio.Source;

public class XarFileSource
implements XarEntrySource {
    private Buffer buffer = new Buffer();
    private File file;
    private Encoding encoding;
    private ChecksumAlgorithm checksumStyle = ChecksumAlgorithm.NONE;
    private String extractedChecksum;
    private String archivedChecksum;

    public XarFileSource(File file) throws IOException {
        this(file, Encoding.NONE);
    }

    public XarFileSource(File file, Encoding encoding) throws IOException {
        this(file, encoding, ChecksumAlgorithm.NONE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XarFileSource(File file, Encoding encoding, ChecksumAlgorithm checksumStyle) throws IOException {
        this.file = file;
        this.encoding = encoding;
        this.checksumStyle = checksumStyle;
        try (BufferedSource fileSource = Okio.buffer(Okio.source(file));){
            fileSource.require(file.length());
            this.extractedChecksum = HashUtils.hashHex(fileSource, checksumStyle);
            switch (encoding) {
                case NONE: {
                    this.buffer.writeAll(fileSource);
                    this.archivedChecksum = this.extractedChecksum;
                    return;
                }
                case GZIP: {
                    try (BufferedSink output = Okio.buffer(new DeflaterSink(this.buffer, new Deflater(9)));){
                        output.writeAll(fileSource);
                    }
                    this.archivedChecksum = HashUtils.hashHex(this.buffer, checksumStyle);
                    return;
                }
                case BZIP2: {
                    throw new UnsupportedEncodingException("Encoding not supported: " + encoding.name());
                }
            }
            return;
        }
    }

    @Override
    public long getLength() {
        return this.buffer.size();
    }

    @Override
    public ChecksumAlgorithm getChecksumAlgorithm() {
        return this.checksumStyle;
    }

    @Override
    public Encoding getEncoding() {
        return this.encoding;
    }

    @Override
    public Source getSource() {
        return this.buffer;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public String getExtractedChecksum() {
        return this.extractedChecksum;
    }

    @Override
    public String getArchivedChecksum() {
        return this.archivedChecksum;
    }
}

