/*
 * Decompiled with CFR 0.152.
 */
package com.sprylab.xar.writer;

import com.sprylab.xar.toc.model.Encoding;
import com.sprylab.xar.utils.StringUtils;
import com.sprylab.xar.writer.XarDirectory;
import com.sprylab.xar.writer.XarFileSource;
import com.sprylab.xar.writer.XarSimpleDirectory;
import com.sprylab.xar.writer.XarSink;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashSet;
import java.util.Set;

public class XarPacker {
    private static final Set<String> DEFAULT_PACK_EXTENSIONS = new HashSet<String>();
    private final File destFile;
    private final XarSink sink;

    public XarPacker(File archiveFile) {
        this.destFile = archiveFile;
        if (this.destFile.exists()) {
            this.destFile.delete();
        }
        this.sink = new XarSink();
    }

    public void addDirectory(File folder, boolean asSubFolder, Set<String> packedExtensions) throws Exception {
        XarSimpleDirectory root = null;
        if (asSubFolder) {
            root = new XarSimpleDirectory(folder.getName());
            this.sink.addDirectory(root, null);
        }
        this.addDirectoryContent(folder, root, packedExtensions == null ? DEFAULT_PACK_EXTENSIONS : null);
    }

    public void addDirectoryContent(File folder, XarDirectory parent, Set<String> packedExtensions) throws Exception {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                XarSimpleDirectory dir = new XarSimpleDirectory(file.getName());
                this.sink.addDirectory(dir, parent);
                this.addDirectoryContent(file, dir, packedExtensions);
                continue;
            }
            boolean compress = packedExtensions.contains(StringUtils.substringAfterLast(file.getName(), "."));
            XarFileSource source2 = new XarFileSource(file, compress ? Encoding.GZIP : Encoding.NONE);
            this.sink.addSource(source2, parent);
        }
    }

    public void write() throws Exception {
        try (FileOutputStream fos = new FileOutputStream(this.destFile);){
            this.sink.write(fos);
        }
    }

    static {
        DEFAULT_PACK_EXTENSIONS.add("txt");
        DEFAULT_PACK_EXTENSIONS.add("htm");
        DEFAULT_PACK_EXTENSIONS.add("html");
        DEFAULT_PACK_EXTENSIONS.add("css");
        DEFAULT_PACK_EXTENSIONS.add("js");
        DEFAULT_PACK_EXTENSIONS.add("xml");
        DEFAULT_PACK_EXTENSIONS.add("stxml");
    }
}

