/*
 * Decompiled with CFR 0.152.
 */
package com.sprylab.xar.writer;

import com.sprylab.xar.XarHeader;
import com.sprylab.xar.toc.TocFactory;
import com.sprylab.xar.toc.model.Checksum;
import com.sprylab.xar.toc.model.ChecksumAlgorithm;
import com.sprylab.xar.toc.model.Data;
import com.sprylab.xar.toc.model.File;
import com.sprylab.xar.toc.model.SimpleChecksum;
import com.sprylab.xar.toc.model.ToC;
import com.sprylab.xar.toc.model.Type;
import com.sprylab.xar.utils.HashUtils;
import com.sprylab.xar.writer.XarDirectory;
import com.sprylab.xar.writer.XarEntrySource;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.DeflaterSink;
import okio.Okio;
import okio.Sink;

public class XarSink {
    private static final long CHECKSUM_LENGTH_MD5 = 16L;
    private static final long CHECKSUM_LENGTH_SHA1 = 20L;
    private final ChecksumAlgorithm checksumAlgorithm;
    private final ToC toc = new ToC();
    private final List<File> files = new ArrayList<File>();
    private final List<XarEntrySource> sources = new ArrayList<XarEntrySource>();
    private final Map<XarDirectory, File> dirMap = new HashMap<XarDirectory, File>();
    private long currentOffset;
    private int id;

    public XarSink() {
        this(ChecksumAlgorithm.SHA1);
    }

    public XarSink(ChecksumAlgorithm checksumAlgorithm) {
        long checksumLength;
        this.checksumAlgorithm = checksumAlgorithm;
        switch (checksumAlgorithm) {
            default: {
                checksumLength = 0L;
                break;
            }
            case SHA1: {
                checksumLength = 20L;
                break;
            }
            case MD5: {
                checksumLength = 16L;
            }
        }
        this.toc.setCreationTime(new Date());
        this.toc.setFiles(this.files);
        Checksum checksum = new Checksum();
        this.toc.setChecksum(checksum);
        checksum.setStyle(checksumAlgorithm);
        checksum.setSize(checksumLength);
        checksum.setOffset(0L);
        this.currentOffset = checksumLength;
    }

    public void addSource(XarEntrySource source2) {
        this.addSource(source2, null);
    }

    public void addSource(XarEntrySource source2, XarDirectory parent) {
        this.sources.add(source2);
        File file = new File();
        file.setType(Type.FILE);
        file.setName(source2.getName());
        file.setId(String.valueOf(this.id++));
        Date lastModifiedDate = new Date(source2.getLastModified());
        file.setMtime(lastModifiedDate);
        file.setCtime(lastModifiedDate);
        Data data = new Data();
        data.setOffset(this.currentOffset);
        data.setLength(source2.getLength());
        data.setSize(source2.getSize());
        this.currentOffset += source2.getLength();
        ChecksumAlgorithm checksumStyle = source2.getChecksumAlgorithm();
        if (checksumStyle != null && checksumStyle != ChecksumAlgorithm.NONE) {
            SimpleChecksum extractedChecksum = new SimpleChecksum();
            extractedChecksum.setStyle(checksumStyle);
            extractedChecksum.setValue(source2.getExtractedChecksum() == null ? "0" : source2.getExtractedChecksum());
            data.setExtractedChecksum(extractedChecksum);
            data.setUnarchivedChecksum(extractedChecksum);
            SimpleChecksum archivedChecksum = new SimpleChecksum();
            archivedChecksum.setStyle(checksumStyle);
            archivedChecksum.setValue(source2.getArchivedChecksum() == null ? "0" : source2.getArchivedChecksum());
            data.setArchivedChecksum(archivedChecksum);
        }
        data.setEncoding(source2.getEncoding());
        file.setData(data);
        this.addFile(file, parent);
    }

    public void addDirectory(XarDirectory dir, XarDirectory parent) {
        File file = new File();
        file.setType(Type.DIRECTORY);
        file.setName(dir.getName());
        file.setId(String.valueOf(this.id++));
        this.addFile(file, parent);
        this.dirMap.put(dir, file);
    }

    private void addFile(File file, XarDirectory parent) {
        if (parent == null) {
            this.files.add(file);
        } else {
            File parentFile = this.dirMap.get(parent);
            if (parentFile == null) {
                throw new IllegalArgumentException("Unknown parent.");
            }
            List<File> children = parentFile.getChildren();
            if (children == null) {
                children = new ArrayList<File>();
                parentFile.setChildren(children);
            }
            children.add(file);
        }
    }

    public void write(OutputStream output) throws Exception {
        Buffer tocCompressedBuffer;
        long tocBufferSize;
        Buffer buffer = new Buffer();
        try (Buffer tocBuffer = new Buffer();){
            TocFactory.toOutputStream(this.toc, tocBuffer.outputStream());
            tocBufferSize = tocBuffer.size();
            tocCompressedBuffer = new Buffer();
            try (DeflaterSink deflaterSink = new DeflaterSink(tocCompressedBuffer, new Deflater(9));){
                deflaterSink.write(tocBuffer, tocBuffer.size());
            }
        }
        long tocCompressedBufferSize = tocCompressedBuffer.size();
        ByteString tocCompressedBufferHash = HashUtils.hash(tocCompressedBuffer, this.checksumAlgorithm);
        buffer.write(XarHeader.createHeader(tocCompressedBufferSize, tocBufferSize, this.checksumAlgorithm));
        buffer.writeAll(tocCompressedBuffer);
        if (tocCompressedBufferHash != null) {
            buffer.write(tocCompressedBufferHash);
        }
        for (XarEntrySource xs : this.sources) {
            BufferedSource source2 = Okio.buffer(xs.getSource());
            try {
                buffer.writeAll(source2);
            }
            finally {
                if (source2 == null) continue;
                source2.close();
            }
        }
        try (Sink sink2 = Okio.sink(output);){
            buffer.readAll(sink2);
        }
    }
}

