/*
 * Decompiled with CFR 0.152.
 */
package com.sprylab.xar;

import com.sprylab.xar.HttpException;
import com.sprylab.xar.XarException;
import com.sprylab.xar.XarSource;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;

public class HttpXarSource
extends XarSource {
    private final String url;
    private final OkHttpClient okHttpClient;

    public HttpXarSource(String url) {
        this(url, null);
    }

    public HttpXarSource(String url, OkHttpClient okHttpClient) {
        this.url = url;
        this.okHttpClient = okHttpClient == null ? new OkHttpClient() : okHttpClient;
    }

    public BufferedSource getRange(long offset, long length) throws IOException {
        return this.executeRangeRequest(offset, length);
    }

    public long getSize() throws XarException {
        return this.executeContentLengthRequest();
    }

    public String toString() {
        return String.format("HttpXarSource{url='%s'}", this.url);
    }

    public String getUrl() {
        return this.url;
    }

    private BufferedSource executeRangeRequest(long offset, long length) throws XarException {
        try {
            Request request = new Request.Builder().get().header("Range", String.format("bytes=%d-%d", offset, offset + length - 1L)).url(this.url).build();
            Call call = this.okHttpClient.newCall(request);
            Response response = call.execute();
            if (response.isSuccessful()) {
                return Okio.buffer((Source)response.body().source());
            }
            response.close();
            throw new HttpException(String.format("Error executing request: %d %s", response.code(), response.message()), response);
        }
        catch (IOException e) {
            throw new XarException("Error reading contents", (Throwable)e);
        }
    }

    private long executeContentLengthRequest() throws XarException {
        try {
            Request request = new Request.Builder().head().url(this.url).build();
            Call call = this.okHttpClient.newCall(request);
            Response response = call.execute();
            if (response.isSuccessful()) {
                String contentLength = response.header("Content-Length");
                return Long.valueOf(contentLength);
            }
            response.close();
            throw new HttpException(String.format("Error executing request: %d %s", response.code(), response.message()), response);
        }
        catch (IOException | NumberFormatException e) {
            throw new XarException("Error reading content length", (Throwable)e);
        }
    }
}

