package dev.hydraulic.types.machines;

import java.util.Objects;

class LinuxMachineImpl extends MachineImpl implements LinuxMachine {
    private final CLibrary cLibrary;
    private final String distribution;

    LinuxMachineImpl(CPUArchitecture cpu, CLibrary cLibrary, String distribution) {
        super(OperatingSystems.Linux, cpu);
        this.cLibrary = cLibrary;
        this.distribution = distribution;
    }

    @Override
    public CLibrary getCLibrary() {
        return cLibrary;
    }

    @Override
    public String getDistributionReverseDNSName() {
        return distribution;
    }

    @Override
    public String toString() {
        return super.toString() + "." + cLibrary.getIdentifier();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        LinuxMachineImpl that = (LinuxMachineImpl) o;
        return cLibrary.equals(that.cLibrary) && Objects.equals(distribution, that.distribution);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), cLibrary, distribution);
    }
}
