package dev.hydraulic.types.machines;

import java.util.Set;

/**
 * Base interface for objects that represents some component or interface of a computer that affects application compatibility.
 */
public interface MachineCompatibilityAspect {
    /**
     * Should return the display name of an operating system, suitable for presentation to humans. The display name may have unusual
     * capitalization, slashes in the middle of it etc.
     */
    String getDisplayName();

    /**
     * The operating system name in a form suitable for use as an identifier in code or filing systems, i.e. all lower case with no
     * punctuation or symbols.
     */
    String getIdentifier();

    /**
     * A set containing the {@link #getIdentifier() identifier} and any other strings that are widely used in the industry to identify this
     * OS, all in lower case. Unlike {@link #getIdentifier()}, the strings returned here may contain punctuation or space characters.
     */
    Set<String> getAliases();

    /**
     * Returns the display name of the organization that makes this OS, or "Open source".
     */
    String getVendor();
}
