package dev.hydraulic.types.machines;

import java.util.Objects;

class MachineImpl implements Machine {
    private final OperatingSystem os;
    private final CPUArchitecture cpu;

    MachineImpl(OperatingSystem os, CPUArchitecture cpu) {
        this.os = os;
        this.cpu = cpu;
    }

    @Override
    public OperatingSystem getOS() {
        return os;
    }

    @Override
    public CPUArchitecture getCPU() {
        return cpu;
    }

    @Override
    public int compareTo(Machine o) {
        return toString().compareTo(o.toString());
    }

    /**
     * Returns the short dot-separated string form of the machine.
     */
    @Override
    public String toString() {
        return os.getIdentifier() + "." + cpu.getIdentifier();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof MachineImpl)) return false;
        MachineImpl machine = (MachineImpl) o;
        return os.equals(machine.os) && cpu.equals(machine.cpu);
    }

    @Override
    public int hashCode() {
        return Objects.hash(os, cpu);
    }
}
