package dev.hydraulic.types.machines;

import java.util.Set;

/**
 * Thrown if a name or alias isn't recognized. The exception message lists all known aliases.
 */
public class UnrecognizedAliasException extends IllegalArgumentException {
    /**
     * The name that wasn't known.
     */
    public final String requested;

    /**
     * The available options.
     */
    public final Set<String> known;

    /**
     * Creates the exception object.
     *
     * @param requested The name that wasn't known.
     */
    UnrecognizedAliasException(String requested, Set<String> known) {
        super("Unrecognized operating system " + requested + ": known names include " + String.join(", ", known));
        this.requested = requested;
        this.known = known;
    }
}
