package dev.hydraulic.types.mimetyped;

/**
 * A root marker interfaces for interfaces representing MIME types, arranged in a sub-typing relationships.
 *
 * These types exist mostly for reflection, type inference and extension functions. They don't provide any actual functionality. Therefore,
 * you can simply not include them in runtime distributions (e.g. use a {@code compileOnly} dependency in Gradle).
 *
 * If one is missing, you can simply use the higher level registry type (application, image) etc, which means 'wildcard', or add your own,
 * or just not use those types at all. Encode dashes as underscores and stay true to the original case of the MIME type.
 */
public interface MimeType {
    // https://www.iana.org/assignments/media-types/media-types.xhtml

    interface application extends MimeType {
        interface gzip extends application {}
        interface octetStream extends application {}
        interface vnd extends application {}
        interface xml extends application {}
    }

    interface audio extends MimeType {
        interface aac extends audio {}
        interface mp4 extends audio {}
        interface ogg extends audio {}
        interface speex extends audio {}
        interface vorbis extends audio {}
        interface vnd extends audio {}
        interface webm extends audio {}
    }
    interface font extends MimeType {}
    interface example extends MimeType {}

    interface image extends MimeType {
        interface gif extends image {}
        interface jpeg extends image {}
        interface png extends image {}
        interface svg extends image {}
        interface tiff extends image {}
        interface webp extends image {}
        interface vnd extends application {}
    }

    interface message extends MimeType {}
    interface model extends MimeType {}
    interface multipart extends MimeType {
        interface byteranges extends multipart {}
        interface form_data extends multipart {}
    }

    interface text extends MimeType {
        interface css extends application {}
        interface csv extends application {}
        interface html extends application {}
        interface javascript extends application {}
        interface json extends application {}
        interface markdown extends application {}
        interface plain extends application {}
        interface rtf extends application {}
        interface vnd extends application {}
    }

    interface video extends MimeType {
        interface mp4 extends video {}
        interface webm extends video {}
    }


    // TODO(high): Add the rest.
}
