package dev.hydraulic.types.mimetyped;

/**
 * Implementations wrap an object (e.g. string, byte array, byte buffer, stream, or any other object) with an associated MIME type.
 * Implementations of this interface may become value types in future releases of Java.
 *
 * @param <T> The type of object that is wrapped.
 * @param <M> A marker type encoding the MIME type into the Java type system - not used for anything at runtime, but can be useful for
 *            enhanced type safety, documentation, extension functions and reflection.
 */
public interface MimeTyped<T, M extends MimeType> {
    /** The wrapped content. */
    T content();

    /** The MIME type. */
    String mimeType();
}
