/*
 * Decompiled with CFR 0.152.
 */
package dev.hydraulic.types.machines;

import dev.hydraulic.types.machines.CPUArchitectures;
import dev.hydraulic.types.machines.MachineCompatibilityAspect;
import dev.hydraulic.types.machines.UnrecognizedAliasException;
import java.util.Locale;

public interface CPUArchitecture
extends MachineCompatibilityAspect {
    public static CPUArchitecture fromOrNull(String name) {
        if (name.isBlank()) {
            throw new IllegalArgumentException("name is blank");
        }
        return CPUArchitectures.ALIAS_MAP.get(name.toLowerCase(Locale.ROOT));
    }

    public static CPUArchitecture fromOrUnknown(String name) {
        CPUArchitecture cpu = CPUArchitecture.fromOrNull(name);
        return cpu != null ? cpu : CPUArchitectures.UNKNOWN;
    }

    public static CPUArchitecture from(String name) {
        CPUArchitecture lib = CPUArchitecture.fromOrNull(name);
        if (lib == null) {
            throw new UnrecognizedAliasException(name, CPUArchitectures.ALIAS_MAP.keySet());
        }
        return lib;
    }
}

