/*
 * Decompiled with CFR 0.152.
 */
package dev.hydraulic.types.machines;

import dev.hydraulic.types.machines.CPUArchitecture;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public enum CPUArchitectures implements CPUArchitecture
{
    X86("Intel", "x86", "i386", "x32", "x86_32", "x86-32"),
    AMD64("AMD", "amd64", "x64", "x86-64", "x86_64"),
    AARCH64("ARM", "aarch64", "arm64", "armv8"),
    ARM7("ARM", "arm7", "arm32", "arm"),
    RISCV("Open source", "riscv", "riscv64", "risc-v"),
    ZARCH("IBM", "zarch", "s390", "s390x"),
    UNKNOWN("Unknown", "unknown", "other");

    private final String vendor;
    private final Set<String> aliases;
    public static final Map<String, CPUArchitecture> ALIAS_MAP;

    private CPUArchitectures(String vendor, String ... names) {
        this.vendor = vendor;
        this.aliases = Set.of(names);
    }

    @Override
    public String getDisplayName() {
        return this.name();
    }

    @Override
    public String getIdentifier() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public Set<String> getAliases() {
        return this.aliases;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    static {
        HashMap<String, CPUArchitectures> map = new HashMap<String, CPUArchitectures>();
        for (CPUArchitectures value : CPUArchitectures.values()) {
            for (String alias : value.aliases) {
                map.put(alias, value);
            }
        }
        ALIAS_MAP = Collections.unmodifiableMap(map);
    }
}

