/*
 * Decompiled with CFR 0.152.
 */
package dev.hydraulic.types.machines;

import dev.hydraulic.types.machines.CLibrary;
import dev.hydraulic.types.machines.CPUArchitecture;
import dev.hydraulic.types.machines.LinuxMachine;
import dev.hydraulic.types.machines.MachineImpl;
import dev.hydraulic.types.machines.OperatingSystems;
import java.util.Objects;

class LinuxMachineImpl
extends MachineImpl
implements LinuxMachine {
    private final CLibrary cLibrary;
    private final String distribution;

    LinuxMachineImpl(CPUArchitecture cpu, CLibrary cLibrary, String distribution) {
        super(OperatingSystems.Linux, cpu);
        this.cLibrary = cLibrary;
        this.distribution = distribution;
    }

    @Override
    public CLibrary getCLibrary() {
        return this.cLibrary;
    }

    @Override
    public String getDistributionReverseDNSName() {
        return this.distribution;
    }

    @Override
    public String toString() {
        return super.toString() + "." + this.cLibrary.getIdentifier();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LinuxMachineImpl that = (LinuxMachineImpl)o;
        return this.cLibrary.equals(that.cLibrary) && Objects.equals(this.distribution, that.distribution);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cLibrary, this.distribution);
    }
}

