/*
 * Decompiled with CFR 0.152.
 */
package dev.hydraulic.types.machines;

import dev.hydraulic.types.machines.CLibraries;
import dev.hydraulic.types.machines.CLibrary;
import dev.hydraulic.types.machines.CPUArchitecture;
import dev.hydraulic.types.machines.CPUArchitectures;
import dev.hydraulic.types.machines.LinuxMachine;
import dev.hydraulic.types.machines.LinuxMachineImpl;
import dev.hydraulic.types.machines.MachineImpl;
import dev.hydraulic.types.machines.OperatingSystem;
import dev.hydraulic.types.machines.OperatingSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public interface Machine
extends Comparable<Machine> {
    public static final LinuxMachine LINUX_AMD64 = LinuxMachine.of(CPUArchitectures.AMD64, CLibraries.GLIBC);
    public static final LinuxMachine LINUX_AARCH64 = LinuxMachine.of(CPUArchitectures.AARCH64, CLibraries.GLIBC);
    public static final LinuxMachine LINUX_AMD64_MUSLC = LinuxMachine.of(CPUArchitectures.AMD64, CLibraries.MUSLC);
    public static final LinuxMachine LINUX_AARCH64_MUSLC = LinuxMachine.of(CPUArchitectures.AARCH64, CLibraries.MUSLC);
    public static final Machine MACOS_AMD64 = Machine.of(OperatingSystems.macOS, CPUArchitectures.AMD64);
    public static final Machine MACOS_AARCH64 = Machine.of(OperatingSystems.macOS, CPUArchitectures.AARCH64);
    public static final Machine WINDOWS_AMD64 = Machine.of(OperatingSystems.Windows, CPUArchitectures.AMD64);
    public static final Machine WINDOWS_AARCH64 = Machine.of(OperatingSystems.Windows, CPUArchitectures.AARCH64);

    public OperatingSystem getOS();

    public CPUArchitecture getCPU();

    public static Machine of(OperatingSystem os, CPUArchitecture cpu) {
        if (os == OperatingSystems.Linux) {
            return new LinuxMachineImpl(cpu, CLibraries.GLIBC, null);
        }
        return new MachineImpl(os, cpu);
    }

    public static Machine parse(String spec) {
        String[] components = spec.split(Pattern.quote("."));
        OperatingSystem os = OperatingSystem.from(components[0]);
        CPUArchitecture arch = components.length > 1 ? CPUArchitecture.from(components[1]) : (os == OperatingSystems.Windows || os == OperatingSystems.Linux ? CPUArchitectures.AMD64 : (OperatingSystems.Families.apple().contains(os) ? CPUArchitectures.AARCH64 : CPUArchitectures.UNKNOWN));
        if (os == OperatingSystems.Linux) {
            CLibrary cLibrary = CLibraries.GLIBC;
            if (components.length > 2) {
                cLibrary = CLibrary.from(components[2]);
            }
            String distro = null;
            if (components.length > 3) {
                distro = Arrays.stream(components).skip(3L).collect(Collectors.joining("."));
            }
            return new LinuxMachineImpl(arch, cLibrary, distro);
        }
        if (components.length >= 3) {
            throw new IllegalArgumentException("The third component of a machine name is only defined for Linux. You specified: " + spec);
        }
        return new MachineImpl(os, arch);
    }

    /*
     * WARNING - void declaration
     */
    public static Set<Machine> parseAll(String spec, boolean supported) {
        void var7_22;
        HashSet<Machine> result = new HashSet<Machine>();
        if (spec.equals("*")) {
            for (OperatingSystems os2 : OperatingSystems.values()) {
                if (os2 == OperatingSystems.UNKNOWN) continue;
                result.addAll(Machine.parseAll(os2.getIdentifier(), supported));
            }
            return result;
        }
        String[] components = spec.split(Pattern.quote("."));
        if (components.length == 0) {
            return result;
        }
        OperatingSystem os = OperatingSystem.from(components[0]);
        if (components.length == 1) {
            if (!supported) {
                void var7_17;
                CPUArchitectures[] cPUArchitecturesArray = CPUArchitectures.values();
                int os2 = cPUArchitecturesArray.length;
                boolean bl = false;
                while (var7_17 < os2) {
                    CPUArchitectures cpu = cPUArchitecturesArray[var7_17];
                    if (cpu != CPUArchitectures.UNKNOWN) {
                        result.addAll(Machine.parseAll(os.getIdentifier() + "." + cpu.getIdentifier(), supported));
                    }
                    ++var7_17;
                }
            } else {
                HashSet<CPUArchitectures> cpus = new HashSet<CPUArchitectures>();
                if (os == OperatingSystems.macOS || os == OperatingSystems.Windows || os == OperatingSystems.ChromeOS || os == OperatingSystems.Android) {
                    cpus.add(CPUArchitectures.AMD64);
                    cpus.add(CPUArchitectures.AARCH64);
                } else if (os == OperatingSystems.Linux || os == OperatingSystems.FreeBSD || os == OperatingSystems.OpenBSD || os == OperatingSystems.NetBSD) {
                    Collections.addAll(cpus, CPUArchitectures.values());
                    cpus.remove(CPUArchitectures.UNKNOWN);
                } else if (os == OperatingSystems.zOS) {
                    cpus.add(CPUArchitectures.ZARCH);
                } else if (OperatingSystems.Families.apple().contains(os)) {
                    cpus.add(CPUArchitectures.AARCH64);
                    if (os == OperatingSystems.iOS) {
                        cpus.add(CPUArchitectures.ARM7);
                    }
                } else if (os == OperatingSystems.Solaris) {
                    cpus.add(CPUArchitectures.AMD64);
                } else {
                    cpus.add(CPUArchitectures.UNKNOWN);
                }
                for (CPUArchitecture cPUArchitecture : cpus) {
                    result.addAll(Machine.parseAll(os.getIdentifier() + "." + cPUArchitecture.getIdentifier(), true));
                }
            }
            return result;
        }
        CPUArchitecture cpu = CPUArchitecture.from(components[1]);
        if (components.length == 2) {
            if (os == OperatingSystems.Linux) {
                for (CLibraries cLib : CLibraries.values()) {
                    result.addAll(Machine.parseAll(os.getIdentifier() + "." + cpu.getIdentifier() + "." + cLib.getIdentifier(), supported));
                }
            } else {
                result.add(new MachineImpl(os, cpu));
            }
            return result;
        }
        if (os != OperatingSystems.Linux) {
            throw new IllegalArgumentException("The third component of a machine name is only defined for Linux. You specified: " + spec);
        }
        CLibrary cLibrary = CLibrary.from(components[2]);
        Object var7_20 = null;
        if (components.length > 3) {
            String string = Arrays.stream(components).skip(3L).collect(Collectors.joining("."));
        }
        result.add(LinuxMachine.of(cpu, cLibrary, (String)var7_22));
        return result;
    }

    public static Machine current() {
        boolean isWindows = System.getProperty("os.name").startsWith("Windows");
        boolean isMac = System.getProperty("os.name").toLowerCase(Locale.ROOT).startsWith("mac");
        boolean isLinux = System.getProperty("os.name").toLowerCase(Locale.ROOT).startsWith("linux");
        OperatingSystems os = isWindows ? OperatingSystems.Windows : (isMac ? OperatingSystems.macOS : (isLinux ? OperatingSystems.Linux : OperatingSystems.UNKNOWN));
        String cpuArch = System.getProperty("os.arch");
        if (cpuArch == null) {
            throw new NullPointerException("The os.arch system property is not available.");
        }
        CPUArchitecture cpu = CPUArchitecture.fromOrUnknown(cpuArch);
        if (os == OperatingSystems.Linux) {
            CLibraries cLib = CLibraries.GLIBC;
            if (Files.exists(Path.of("/lib/libc.musl-x86_64.so.1", new String[0]), new LinkOption[0])) {
                cLib = CLibraries.MUSLC;
            }
            return LinuxMachine.of(cpu, cLib);
        }
        return Machine.of(os, cpu);
    }
}

