/*
 * Decompiled with CFR 0.152.
 */
package dev.hydraulic.types.machines;

import dev.hydraulic.types.machines.MachineCompatibilityAspect;
import dev.hydraulic.types.machines.OperatingSystems;
import dev.hydraulic.types.machines.UnrecognizedAliasException;
import java.util.Locale;

public interface OperatingSystem
extends MachineCompatibilityAspect {
    public static OperatingSystem fromOrNull(String name) {
        if (name.isBlank()) {
            throw new IllegalArgumentException("name is blank");
        }
        return OperatingSystems.ALIAS_MAP.get(name.toLowerCase(Locale.ROOT));
    }

    public static OperatingSystem fromOrUnknown(String name) {
        OperatingSystem os = OperatingSystem.fromOrNull(name);
        return os != null ? os : OperatingSystems.UNKNOWN;
    }

    public static OperatingSystem from(String name) {
        OperatingSystem os = OperatingSystem.fromOrNull(name);
        if (os == null) {
            throw new UnrecognizedAliasException(name, OperatingSystems.ALIAS_MAP.keySet());
        }
        return os;
    }
}

