/*
 * Decompiled with CFR 0.152.
 */
package dev.hydraulic.types.machines;

import dev.hydraulic.types.machines.OperatingSystem;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public enum OperatingSystems implements OperatingSystem
{
    Linux("Open source", Collections.singleton("linux")),
    macOS("Apple", Set.of("mac", "macos", "osx", "darwin")),
    Windows("Microsoft", Set.of("windows", "win", "win32", "win64")),
    Android("Google", Set.of("android")),
    iOS("Apple", Set.of("ios", "iphoneos")),
    iPadOS("Apple", Set.of("ipados", "ipad")),
    tvOS("Apple", Set.of("tvos")),
    watchOS("Apple", Set.of("watchos")),
    FreeBSD("Open source", Set.of("freebsd")),
    NetBSD("Open source", Set.of("netbsd")),
    OpenBSD("Open source", Set.of("openbsd")),
    ChromeOS("Google", Set.of("chromeos", "cros")),
    Solaris("Open source", Set.of("solaris", "illumos")),
    zOS("IBM", Set.of("zos", "z/os")),
    UNKNOWN("Unknown", Set.of("other", "unknown"));

    private final String vendor;
    private final Set<String> aliases;
    public static final Map<String, OperatingSystem> ALIAS_MAP;

    private OperatingSystems(String vendor, Set<String> aliases) {
        this.vendor = vendor;
        this.aliases = aliases;
    }

    @Override
    public String getDisplayName() {
        if (this == zOS) {
            return "z/OS";
        }
        return this.name();
    }

    @Override
    public String getIdentifier() {
        if (this == macOS) {
            return "mac";
        }
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public Set<String> getAliases() {
        return this.aliases;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    static {
        HashMap<String, OperatingSystems> map = new HashMap<String, OperatingSystems>();
        for (OperatingSystems value : OperatingSystems.values()) {
            for (String alias : value.aliases) {
                map.put(alias, value);
            }
        }
        ALIAS_MAP = Collections.unmodifiableMap(map);
    }

    public static class Families {
        private Families() {
        }

        public static Set<OperatingSystem> unix() {
            return Set.of(Linux, FreeBSD, NetBSD, OpenBSD, Solaris, macOS);
        }

        public static Set<OperatingSystem> apple() {
            return Set.of(macOS, watchOS, tvOS, iOS, iPadOS);
        }

        public static Set<OperatingSystem> linuxKernelBased() {
            return Set.of(Linux, ChromeOS, Android);
        }
    }
}

