/*
 * Decompiled with CFR 0.152.
 */
package dev.hydraulic.types.mimetyped;

import dev.hydraulic.types.mimetyped.MimeType;
import dev.hydraulic.types.mimetyped.MimeTyped;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class MimeTypedObject<T, M extends MimeType>
implements MimeTyped<T, M> {
    @NotNull
    private final T content;
    @NotNull
    private final String mimeType;

    public static <T> MimeTypedObject<T, MimeType.application.octetStream> octetStream(T content) {
        return new MimeTypedObject(content, "application/octet-stream");
    }

    public static <T> MimeTypedObject<T, MimeType.image> image(T content, String subtype) {
        return new MimeTypedObject(content, "image/" + subtype);
    }

    public static <T> MimeTypedObject<T, MimeType.application> application(T content, String subtype) {
        return new MimeTypedObject(content, "application/" + subtype);
    }

    public MimeTypedObject(T content, String mimeType) {
        assert (mimeType.length() > 0);
        this.content = Objects.requireNonNull(content);
        this.mimeType = Objects.requireNonNull(mimeType);
    }

    @Override
    public String mimeType() {
        return this.mimeType;
    }

    @Override
    public T content() {
        return this.content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MimeTypedObject mimeTyped = (MimeTypedObject)o;
        return this.content.equals(mimeTyped.content) && this.mimeType.equals(mimeTyped.mimeType);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.mimeType);
    }

    public String toString() {
        return "[" + this.mimeType + "] " + this.content;
    }

    static {
        MimeTypedObject<byte[], MimeType.image> mimeTypedObject = MimeTypedObject.image(new byte[]{1, 2, 3}, "gif");
    }
}

