/*
 * Decompiled with CFR 0.152.
 */
package dev.hydraulic.types.mimetyped;

import dev.hydraulic.types.mimetyped.MimeType;
import dev.hydraulic.types.mimetyped.MimeTyped;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.IntStream;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

public final class MimeTypedString<M extends MimeType>
implements CharSequence,
Serializable,
Comparable<MimeTypedString<M>>,
MimeTyped<String, M> {
    private final String content;
    private final String mimeType;
    private static final long serialVersionUID = 5289920660193190558L;
    public static Comparator<MimeTypedString<?>> MIME_TYPE_THEN_CONTENT = Comparator.comparing(a -> a.mimeType).thenComparing(a -> a.content);

    public static MimeTypedString<MimeType.text> text(String subtype, String text2) {
        assert (subtype.length() > 0);
        return new MimeTypedString<MimeType.text>(text2, "text/" + subtype);
    }

    public static MimeTypedString<MimeType.text.plain> plain(String text2) {
        return new MimeTypedString<MimeType.text.plain>("plain", text2);
    }

    public static MimeTypedString<MimeType.application.xml> xml(@Language(value="xml") String xml2) {
        return new MimeTypedString<MimeType.application.xml>(xml2, "application/xml");
    }

    public static MimeTypedString<MimeType.text.json> json(@Language(value="json") String json2) {
        return new MimeTypedString<MimeType.text.json>(json2, "application/json");
    }

    public static MimeTypedString<MimeType.text.html> html(@Language(value="html") String html2) {
        return new MimeTypedString<MimeType.text.html>("html", html2);
    }

    public static MimeTypedString<MimeType.text.csv> csv(@Language(value="csv") String csv2) {
        return new MimeTypedString<MimeType.text.csv>("csv", csv2);
    }

    public static MimeTypedString<MimeType.text.markdown> markdown(@Language(value="Markdown") String text2) {
        return new MimeTypedString<MimeType.text.markdown>(text2, "text/markdown");
    }

    public MimeTypedString(String content, String mimeType) {
        this.content = content;
        this.mimeType = mimeType;
    }

    @Override
    public String content() {
        return this.content;
    }

    @Override
    public String mimeType() {
        return this.mimeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MimeTypedString that = (MimeTypedString)o;
        return this.content.equals(that.content) && this.mimeType.equals(that.mimeType);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.mimeType);
    }

    @Override
    public String toString() {
        return this.content;
    }

    @Override
    public int length() {
        return this.content.length();
    }

    @Override
    public char charAt(int index) {
        return this.content.charAt(index);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return this.content.subSequence(start, end);
    }

    @Override
    @NotNull
    public IntStream chars() {
        return this.content.chars();
    }

    @Override
    @NotNull
    public IntStream codePoints() {
        return this.content.codePoints();
    }

    @Override
    public int compareTo(@NotNull MimeTypedString o) {
        return MIME_TYPE_THEN_CONTENT.compare(this, o);
    }
}

