package hydraulic.types.printables

/**
 * A wrapper for a [CharSequence] i.e. [String] that associates it with a type of 'notice', which is in practice used to render an icon next
 * to the string when printed.
 *
 * Although [CharSequence] doesn't enforce it, notices should be immutable once created and may become value types in future versions.
 *
 * @property string the string or string-like object to display to the user.
 */
sealed class Notice(val string: CharSequence) : CharSequence by string {
    override fun toString(): String = string.toString()
    override fun equals(other: Any?): Boolean = string == other
    override fun hashCode(): Int = string.hashCode()

    /** A string wrapper that marks it as an informational [Notice]. */
    class Info(string: CharSequence) : Notice(string)

    /** A string wrapper that marks it as a warning [Notice]. */
    class Warning(string: CharSequence) : Notice(string)

    /** A string wrapper that marks it as an error [Notice]. */
    class Error(string: CharSequence) : Notice(string)
}
