package hydraulic.types.progress

/**
 * A specialization of [Progress] that promises the contents of the report won't change, and which offers convenient utilities for
 * altering aspects of the report.
 */
interface ImmutableProgress : Progress {
    /** Returns a copy of this report with the specified value for completed. */
    fun withCompleted(value: Long): ImmutableProgress

    /** Returns a copy of this report with the [completed] field incremented by [value] and capped to [expectedTotal]. */
    fun withIncremented(value: Long): ImmutableProgress

    /**
     * Returns a copy of this report with the specified expected total. If [completed] is higher than the new expected total, it is set
     * to the new value (i.e. 100% and thus [complete]).
     */
    fun withExpectedTotal(value: Long): ImmutableProgress

    /**
     * Returns a copy of this report with the specified message, or null to indicate no message.
     */
    fun withMessage(message: String?): ImmutableProgress
    
    /**
     * Returns a copy of this report with the specified sub-reports.
     */
    fun withSubReports(subReports: Collection<Progress?>): ImmutableProgress
}
