package dev.hydraulic.types.machines;

class LinuxMachineImpl extends MachineImpl implements LinuxMachine {
    private final CLibrary cLibrary;
    private final String distribution;

    LinuxMachineImpl(CPUArchitecture cpu, CLibrary cLibrary, String distribution) {
        super(OperatingSystems.Linux, cpu);
        this.cLibrary = cLibrary;
        this.distribution = distribution;
    }

    @Override
    public CLibrary getCLibrary() {
        return cLibrary;
    }

    @Override
    public String getDistributionReverseDNSName() {
        return distribution;
    }

    @Override
    public String toString() {
        return super.toString() + "." + cLibrary.getIdentifier();
    }
}
