/*
 * Decompiled with CFR 0.152.
 */
package dev.hydraulic.types.machines;

import dev.hydraulic.types.machines.CLibrary;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public enum CLibraries implements CLibrary
{
    GLIBC(Set.of("glibc", "gnu")),
    MUSLC(Set.of("muslc", "musl", "alpine"));

    private final Set<String> aliases;
    public static final Map<String, CLibrary> ALIAS_MAP;

    private CLibraries(Set<String> aliases) {
        this.aliases = aliases;
    }

    @Override
    public String getDisplayName() {
        return this.getIdentifier();
    }

    @Override
    public String getIdentifier() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public Set<String> getAliases() {
        return this.aliases;
    }

    @Override
    public String getVendor() {
        return "Open source";
    }

    static {
        HashMap<String, CLibraries> map = new HashMap<String, CLibraries>();
        for (CLibraries value : CLibraries.values()) {
            for (String alias : value.aliases) {
                map.put(alias, value);
            }
        }
        ALIAS_MAP = Collections.unmodifiableMap(map);
    }
}

