/*
 * Decompiled with CFR 0.152.
 */
package dev.hydraulic.types.machines;

import dev.hydraulic.types.machines.CLibraries;
import dev.hydraulic.types.machines.MachineCompatibilityAspect;
import dev.hydraulic.types.machines.UnrecognizedAliasException;
import java.util.Locale;

public interface CLibrary
extends MachineCompatibilityAspect {
    public static CLibrary fromOrNull(String name) {
        if (name.isBlank()) {
            throw new IllegalArgumentException("name is blank");
        }
        return CLibraries.ALIAS_MAP.get(name.toLowerCase(Locale.ROOT));
    }

    public static CLibrary from(String name) {
        CLibrary lib = CLibrary.fromOrNull(name);
        if (lib == null) {
            throw new UnrecognizedAliasException(name, CLibraries.ALIAS_MAP.keySet());
        }
        return lib;
    }
}

