/*
 * Decompiled with CFR 0.152.
 */
package dev.hydraulic.types.machines;

import dev.hydraulic.types.machines.CPUArchitecture;
import dev.hydraulic.types.machines.Machine;
import dev.hydraulic.types.machines.OperatingSystem;
import java.util.Objects;

class MachineImpl
implements Machine {
    private final OperatingSystem os;
    private final CPUArchitecture cpu;

    MachineImpl(OperatingSystem os, CPUArchitecture cpu) {
        this.os = os;
        this.cpu = cpu;
    }

    @Override
    public OperatingSystem getOS() {
        return this.os;
    }

    @Override
    public CPUArchitecture getCPU() {
        return this.cpu;
    }

    @Override
    public int compareTo(Machine o) {
        return this.toString().compareTo(o.toString());
    }

    public String toString() {
        return this.os.getIdentifier() + "." + this.cpu.getIdentifier();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MachineImpl)) {
            return false;
        }
        MachineImpl machine = (MachineImpl)o;
        return this.os.equals(machine.os) && this.cpu.equals(machine.cpu);
    }

    public int hashCode() {
        return Objects.hash(this.os, this.cpu);
    }
}

