/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.IOException;
import java.util.List;
import net.jsign.DigestAlgorithm;
import net.jsign.Signable;
import net.jsign.asn1.authenticode.AuthenticodeObjectIdentifiers;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.junit.Assert;

public class SignatureAssert {
    public static void assertTimestamped(String message, CMSSignedData signedData) {
        SignerInformation signerInformation = (SignerInformation)signedData.getSignerInfos().getSigners().iterator().next();
        AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
        Assert.assertNotNull((String)(message + " (missing unauthenticated attributse)"), (Object)unsignedAttributes);
        Attribute authenticodeTimestampAttribute = unsignedAttributes.get(CMSAttributes.counterSignature);
        Attribute rfc3161TimestampAttribute = unsignedAttributes.get(AuthenticodeObjectIdentifiers.SPC_RFC3161_OBJID);
        Assert.assertTrue((String)(message + " (no counter signature attribute found)"), (authenticodeTimestampAttribute != null || rfc3161TimestampAttribute != null ? 1 : 0) != 0);
        if (authenticodeTimestampAttribute != null) {
            Assert.assertNotNull((String)(message + " (counter signature attribute value is null)"), (Object)authenticodeTimestampAttribute.getAttributeValues());
            Assert.assertTrue((String)(message + " (counter signature attribute value is empty)"), (authenticodeTimestampAttribute.getAttributeValues().length > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertNotNull((String)(message + " (counter signature attribute value is null)"), (Object)rfc3161TimestampAttribute.getAttributeValues());
            Assert.assertTrue((String)(message + " (counter signature attribute value is empty)"), (rfc3161TimestampAttribute.getAttributeValues().length > 0 ? 1 : 0) != 0);
        }
    }

    public static void assertSigned(Signable signable, DigestAlgorithm ... algorithms) throws IOException {
        List signatures = signable.getSignatures();
        Assert.assertNotNull((String)"list of signatures null", (Object)signatures);
        Assert.assertEquals((String)"number of signatures", (long)algorithms.length, (long)signatures.size());
        int signaturesSize = signatures.size();
        for (int i = 0; i < signaturesSize; ++i) {
            CMSSignedData signature = (CMSSignedData)signatures.get(i);
            Assert.assertNotNull((String)("signature " + i + " is null"), signatures.get(0));
            SignerInformation si = (SignerInformation)signature.getSignerInfos().getSigners().iterator().next();
            Assert.assertEquals((String)("Digest algorithm of signature " + i), (Object)algorithms[i].oid, (Object)si.getDigestAlgorithmID().getAlgorithm());
            Assert.assertNull((String)("signingTime attribute found in signature " + i), (Object)((SignerInformation)signature.getSignerInfos().iterator().next()).getSignedAttributes().get(CMSAttributes.signingTime));
        }
    }

    public static void assertNotSigned(Signable signable) throws IOException {
        List signatures = signable.getSignatures();
        Assert.assertNotNull((String)"list of signatures null", (Object)signatures);
        Assert.assertTrue((String)"signature found", (boolean)signatures.isEmpty());
    }
}

