/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import com.cedarsoftware.util.io.JsonWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509KeyManager;
import net.jsign.DigestAlgorithm;
import net.jsign.KeyStoreUtils;
import net.jsign.jca.RESTClient;
import net.jsign.jca.SigningService;
import net.jsign.jca.SigningServicePrivateKey;

public class DigiCertOneSigningService
implements SigningService {
    private final Map<String, Map<String, ?>> certificates = new HashMap();
    private final RESTClient client = new RESTClient("https://one.digicert.com/signingmanager/api/v1/", conn -> {
        conn.setRequestProperty("x-api-key", apiKey);
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(new KeyManager[]{keyManager}, null, new SecureRandom());
            ((HttpsURLConnection)conn).setSSLSocketFactory(context.getSocketFactory());
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Unable to load the DigiCert ONE client certificate", e);
        }
    });
    private static final Pattern ID_PATTERN = Pattern.compile("[0-9a-f\\-]+");

    public DigiCertOneSigningService(String apiKey, File keystore, String storepass) {
        this(apiKey, (X509KeyManager)DigiCertOneSigningService.getKeyManager(keystore, storepass));
    }

    public DigiCertOneSigningService(String apiKey, X509KeyManager keyManager) {
    }

    @Override
    public String getName() {
        return "DigiCertONE";
    }

    private Map<String, ?> getCertificateInfo(String alias) throws IOException {
        if (!this.certificates.containsKey(alias)) {
            Map<String, ?> response = this.client.get("certificates?" + (this.isIdentifier(alias) ? "id" : "alias") + "=" + alias);
            for (Object item : (Object[])response.get("items")) {
                Map certificate = (Map)item;
                this.certificates.put((String)certificate.get("id"), certificate);
                this.certificates.put((String)certificate.get("alias"), certificate);
            }
        }
        return this.certificates.get(alias);
    }

    private boolean isIdentifier(String id) {
        return ID_PATTERN.matcher(id).matches();
    }

    @Override
    public List<String> aliases() throws KeyStoreException {
        ArrayList<String> aliases = new ArrayList<String>();
        try {
            Map<String, ?> response = this.client.get("certificates?limit=100&certificate_status=ACTIVE");
            for (Object item : (Object[])response.get("items")) {
                Map certificate = (Map)item;
                this.certificates.put((String)certificate.get("id"), certificate);
                this.certificates.put((String)certificate.get("alias"), certificate);
                aliases.add((String)certificate.get("alias"));
            }
        }
        catch (IOException e) {
            throw new KeyStoreException("Unable to retrieve DigiCert ONE certificate aliases", e);
        }
        return aliases;
    }

    @Override
    public Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        try {
            Map<String, ?> response = this.getCertificateInfo(alias);
            if (response == null) {
                throw new KeyStoreException("Unable to retrieve DigiCert ONE certificate '" + alias + "'");
            }
            ArrayList<String> encodedChain = new ArrayList<String>();
            encodedChain.add((String)response.get("cert"));
            if (response.get("chain") != null) {
                for (Object certificate : (Object[])response.get("chain")) {
                    encodedChain.add((String)((Map)certificate).get("blob"));
                }
            }
            ArrayList<Certificate> chain = new ArrayList<Certificate>();
            for (String encodedCertificate : encodedChain) {
                chain.add(CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(Base64.getDecoder().decode(encodedCertificate))));
            }
            return chain.toArray(new Certificate[0]);
        }
        catch (IOException | CertificateException e) {
            throw new KeyStoreException("Unable to retrieve DigiCert ONE certificate '" + alias + "'", e);
        }
    }

    @Override
    public SigningServicePrivateKey getPrivateKey(String alias, char[] password) throws UnrecoverableKeyException {
        try {
            Map<String, ?> certificate = this.getCertificateInfo(alias);
            Map keypair = (Map)certificate.get("keypair");
            String keyId = (String)keypair.get("id");
            Map<String, ?> response = this.client.get("/keypairs/" + keyId);
            String algorithm = (String)response.get("key_alg");
            SigningServicePrivateKey key = new SigningServicePrivateKey(keyId, algorithm);
            key.getProperties().put("account", response.get("account"));
            return key;
        }
        catch (IOException e) {
            throw (UnrecoverableKeyException)new UnrecoverableKeyException("Unable to fetch DigiCert ONE private key for the certificate '" + alias + "'").initCause(e);
        }
    }

    @Override
    public byte[] sign(SigningServicePrivateKey privateKey, String algorithm, byte[] data) throws GeneralSecurityException {
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.of(algorithm.substring(0, algorithm.toLowerCase().indexOf("with")));
        data = digestAlgorithm.getMessageDigest().digest(data);
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("account", privateKey.getProperties().get("account"));
        request.put("sig_alg", algorithm);
        request.put("hash", Base64.getEncoder().encodeToString(data));
        try {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("TYPE", "false");
            Map<String, ?> response = this.client.post("https://clientauth.one.digicert.com/signingmanager/api/v1/keypairs/" + privateKey.getId() + "/sign", JsonWriter.objectToJson(request, args));
            String value = (String)response.get("signature");
            return Base64.getDecoder().decode(value);
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }

    private static KeyManager getKeyManager(File keystoreFile, String storepass) {
        try {
            KeyStore keystore = KeyStoreUtils.load(keystoreFile, null, storepass, null);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keystore, storepass.toCharArray());
            return kmf.getKeyManagers()[0];
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load the client certificate for DigiCert ONE", e);
        }
    }
}

