/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import com.cedarsoftware.util.io.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;

class RESTClient {
    private final String endpoint;
    private final BiConsumer<HttpURLConnection, byte[]> authenticationHandler;

    public RESTClient(String endpoint) {
        this.endpoint = endpoint;
        this.authenticationHandler = null;
    }

    public RESTClient(String endpoint, Consumer<HttpURLConnection> authenticationHeaderSupplier) {
        this.endpoint = endpoint;
        this.authenticationHandler = (conn, data) -> authenticationHeaderSupplier.accept((HttpURLConnection)conn);
    }

    public RESTClient(String endpoint, BiConsumer<HttpURLConnection, byte[]> authenticationHeaderSupplier) {
        this.endpoint = endpoint;
        this.authenticationHandler = authenticationHeaderSupplier;
    }

    public Map<String, ?> get(String resource) throws IOException {
        return this.query("GET", resource, null, null);
    }

    public Map<String, ?> post(String resource, String body) throws IOException {
        return this.query("POST", resource, body, null);
    }

    public Map<String, ?> post(String resource, String body, Map<String, String> headers) throws IOException {
        return this.query("POST", resource, body, headers);
    }

    private Map<String, ?> query(String method, String resource, String body, Map<String, String> headers) throws IOException {
        byte[] data;
        URL url = new URL(resource.startsWith("http") ? resource : this.endpoint + resource);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        conn.setRequestProperty("User-Agent", "Jsign (https://ebourg.github.io/jsign/)");
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                conn.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        byte[] byArray = data = body != null ? body.getBytes(StandardCharsets.UTF_8) : null;
        if (this.authenticationHandler != null) {
            this.authenticationHandler.accept(conn, data);
        }
        if (body != null) {
            conn.setDoOutput(true);
            if (!conn.getRequestProperties().containsKey("Content-Type")) {
                conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            }
            conn.setRequestProperty("Content-Length", String.valueOf(data.length));
            conn.getOutputStream().write(data);
        }
        int responseCode = conn.getResponseCode();
        String contentType = conn.getHeaderField("Content-Type");
        if (responseCode < 400) {
            String response = IOUtils.toString((InputStream)conn.getInputStream(), (Charset)StandardCharsets.UTF_8);
            return JsonReader.jsonToMaps((String)response);
        }
        String error = IOUtils.toString((InputStream)conn.getErrorStream(), (Charset)StandardCharsets.UTF_8);
        if (contentType != null && (contentType.startsWith("application/json") || contentType.startsWith("application/x-amz-json-1.1"))) {
            throw new IOException(this.getErrorMessage(JsonReader.jsonToMaps((String)error)));
        }
        throw new IOException("HTTP Error " + responseCode + (conn.getResponseMessage() != null ? " - " + conn.getResponseMessage() : "") + " (" + url + ")");
    }

    private String getErrorMessage(Map<String, ?> response) {
        StringBuilder message = new StringBuilder();
        if (response.get("error") instanceof Map) {
            Map error = (Map)response.get("error");
            if (error.get("code") != null) {
                message.append(error.get("code"));
            }
            if (error.get("status") != null) {
                if (message.length() > 0) {
                    message.append(" - ");
                }
                message.append(error.get("status"));
            }
            if (error.get("message") != null) {
                if (message.length() > 0) {
                    message.append(": ");
                }
                message.append(error.get("message"));
            }
        } else if (response.containsKey("__type")) {
            String error = (String)response.get("__type");
            String description = (String)response.get("message");
            message.append(error).append(": ").append(description);
        } else {
            String error = (String)response.get("error");
            String description = (String)response.get("error_description");
            message.append(error).append(": ").append(description);
        }
        return message.toString();
    }
}

