/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.jsign.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.jsign.bouncycastle.tsp.TSPAlgorithms;

public enum DigestAlgorithm {
    MD5("MD5", TSPAlgorithms.MD5),
    SHA1("SHA-1", TSPAlgorithms.SHA1),
    SHA256("SHA-256", TSPAlgorithms.SHA256),
    SHA384("SHA-384", TSPAlgorithms.SHA384),
    SHA512("SHA-512", TSPAlgorithms.SHA512);

    public final String id;
    public final ASN1ObjectIdentifier oid;

    private DigestAlgorithm(String id, ASN1ObjectIdentifier oid) {
        this.id = id;
        this.oid = oid;
    }

    public static DigestAlgorithm of(String name) {
        if (name == null) {
            return null;
        }
        name = name.toUpperCase().replaceAll("-", "");
        for (DigestAlgorithm algorithm : DigestAlgorithm.values()) {
            if (!algorithm.name().equals(name)) continue;
            return algorithm;
        }
        if ("SHA2".equals(name)) {
            return SHA256;
        }
        return null;
    }

    public static DigestAlgorithm of(ASN1ObjectIdentifier oid) {
        for (DigestAlgorithm algorithm : DigestAlgorithm.values()) {
            if (!algorithm.oid.equals(oid)) continue;
            return algorithm;
        }
        return null;
    }

    public MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(this.id);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static DigestAlgorithm getDefault() {
        return SHA256;
    }
}

