/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.asn1;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import net.jsign.bouncycastle.asn1.ASN1OutputStream;
import net.jsign.bouncycastle.asn1.ASN1ParsingException;
import net.jsign.bouncycastle.asn1.ASN1Primitive;
import net.jsign.bouncycastle.asn1.ASN1String;
import net.jsign.bouncycastle.asn1.DERBitString;
import net.jsign.bouncycastle.asn1.DLBitString;
import net.jsign.bouncycastle.util.Arrays;
import net.jsign.bouncycastle.util.io.Streams;

public abstract class ASN1BitString
extends ASN1Primitive
implements ASN1String {
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected final byte[] data;
    protected final int padBits;

    public ASN1BitString(byte[] byArray, int n) {
        if (byArray == null) {
            throw new NullPointerException("'data' cannot be null");
        }
        if (byArray.length == 0 && n != 0) {
            throw new IllegalArgumentException("zero length data with non-zero pad bits");
        }
        if (n > 7 || n < 0) {
            throw new IllegalArgumentException("pad bits cannot be greater than 7 or less than 0");
        }
        this.data = Arrays.clone(byArray);
        this.padBits = n;
    }

    public String getString() {
        byte[] byArray;
        StringBuffer stringBuffer = new StringBuffer("#");
        try {
            byArray = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new ASN1ParsingException("Internal error encoding BitString: " + iOException.getMessage(), iOException);
        }
        for (int i = 0; i != byArray.length; ++i) {
            stringBuffer.append(table[byArray[i] >>> 4 & 0xF]);
            stringBuffer.append(table[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public byte[] getOctets() {
        if (this.padBits != 0) {
            throw new IllegalStateException("attempt to get non-octet aligned data from BIT STRING");
        }
        return Arrays.clone(this.data);
    }

    public byte[] getBytes() {
        if (0 == this.data.length) {
            return this.data;
        }
        byte[] byArray = Arrays.clone(this.data);
        int n = this.data.length - 1;
        byArray[n] = (byte)(byArray[n] & 255 << this.padBits);
        return byArray;
    }

    public int getPadBits() {
        return this.padBits;
    }

    public String toString() {
        return this.getString();
    }

    public int hashCode() {
        int n = this.data.length;
        if (--n < 0) {
            return 1;
        }
        byte by = (byte)(this.data[n] & 255 << this.padBits);
        int n2 = Arrays.hashCode(this.data, 0, n);
        n2 *= 257;
        return (n2 ^= by) ^ this.padBits;
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        int n;
        if (!(aSN1Primitive instanceof ASN1BitString)) {
            return false;
        }
        ASN1BitString aSN1BitString = (ASN1BitString)aSN1Primitive;
        if (this.padBits != aSN1BitString.padBits) {
            return false;
        }
        byte[] byArray = this.data;
        int n2 = byArray.length;
        byte[] byArray2 = aSN1BitString.data;
        if (n2 != byArray2.length) {
            return false;
        }
        if (--n2 < 0) {
            return true;
        }
        for (n = 0; n < n2; ++n) {
            if (byArray[n] == byArray2[n]) continue;
            return false;
        }
        n = (byte)(byArray[n2] & 255 << this.padBits);
        byte by = (byte)(byArray2[n2] & 255 << this.padBits);
        return n == by;
    }

    static ASN1BitString fromInputStream(int n, InputStream inputStream) throws IOException {
        if (n < 1) {
            throw new IllegalArgumentException("truncated BIT STRING detected");
        }
        int n2 = inputStream.read();
        byte[] byArray = new byte[n - 1];
        if (byArray.length != 0) {
            if (Streams.readFully(inputStream, byArray) != byArray.length) {
                throw new EOFException("EOF encountered in middle of BIT STRING");
            }
            if (n2 > 0 && n2 < 8 && byArray[byArray.length - 1] != (byte)(byArray[byArray.length - 1] & 255 << n2)) {
                return new DLBitString(byArray, n2);
            }
        }
        return new DERBitString(byArray, n2);
    }

    ASN1Primitive toDERObject() {
        return new DERBitString(this.data, this.padBits);
    }

    ASN1Primitive toDLObject() {
        return new DLBitString(this.data, this.padBits);
    }

    abstract void encode(ASN1OutputStream var1, boolean var2) throws IOException;
}

