/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.pqc.jcajce.provider.lms;

import java.io.IOException;
import java.security.PublicKey;
import net.jsign.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.jsign.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import net.jsign.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import net.jsign.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import net.jsign.bouncycastle.pqc.jcajce.interfaces.LMSKey;
import net.jsign.bouncycastle.util.Arrays;

public class BCLMSPublicKey
implements PublicKey,
LMSKey {
    private transient LMSKeyParameters keyParams;

    public BCLMSPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.keyParams = (LMSKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    public final String getAlgorithm() {
        return "LMS";
    }

    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.keyParams);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getFormat() {
        return "X.509";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCLMSPublicKey) {
            BCLMSPublicKey bCLMSPublicKey = (BCLMSPublicKey)object;
            try {
                return Arrays.areEqual(this.keyParams.getEncoded(), bCLMSPublicKey.keyParams.getEncoded());
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return Arrays.hashCode(this.keyParams.getEncoded());
        }
        catch (IOException iOException) {
            return -1;
        }
    }
}

