/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.poi.util;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Locale;
import net.jsign.poi.util.POILogFactory;
import net.jsign.poi.util.POILogger;
import net.jsign.poi.util.RecordFormatException;

public final class IOUtils {
    private static final POILogger logger = POILogFactory.getLogger(IOUtils.class);
    private static byte[] SKIP_BYTE_BUFFER;
    private static int BYTE_ARRAY_MAX_OVERRIDE;

    private IOUtils() {
    }

    private static void checkByteSizeLimit(int length) {
        if (BYTE_ARRAY_MAX_OVERRIDE != -1 && length > BYTE_ARRAY_MAX_OVERRIDE) {
            IOUtils.throwRFE(length, BYTE_ARRAY_MAX_OVERRIDE);
        }
    }

    public static byte[] toByteArray(InputStream stream) throws IOException {
        return IOUtils.toByteArray(stream, Integer.MAX_VALUE);
    }

    public static byte[] toByteArray(InputStream stream, int length) throws IOException {
        return IOUtils.toByteArray(stream, length, Integer.MAX_VALUE);
    }

    public static byte[] toByteArray(InputStream stream, int length, int maxLength) throws IOException {
        int readBytes;
        int len;
        if ((long)length < 0L || (long)maxLength < 0L) {
            throw new RecordFormatException("Can't allocate an array of length < 0");
        }
        if (length != Integer.MAX_VALUE || maxLength != Integer.MAX_VALUE) {
            IOUtils.checkLength(length, maxLength);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream((len = Math.min(length, maxLength)) == Integer.MAX_VALUE ? 4096 : len);
        byte[] buffer = new byte[4096];
        int totalBytes = 0;
        do {
            readBytes = stream.read(buffer, 0, Math.min(buffer.length, len - totalBytes));
            totalBytes += Math.max(readBytes, 0);
            if (readBytes > 0) {
                baos.write(buffer, 0, readBytes);
            }
            IOUtils.checkByteSizeLimit(totalBytes);
        } while (totalBytes < len && readBytes > -1);
        if (maxLength != Integer.MAX_VALUE && totalBytes == maxLength) {
            throw new IOException("MaxLength (" + maxLength + ") reached - stream seems to be invalid.");
        }
        if (len != Integer.MAX_VALUE && totalBytes < len) {
            throw new EOFException("unexpected EOF - expected len: " + len + " - actual len: " + totalBytes);
        }
        return baos.toByteArray();
    }

    private static void checkLength(long length, int maxLength) {
        if (BYTE_ARRAY_MAX_OVERRIDE > 0) {
            if (length > (long)BYTE_ARRAY_MAX_OVERRIDE) {
                IOUtils.throwRFE(length, BYTE_ARRAY_MAX_OVERRIDE);
            }
        } else if (length > (long)maxLength) {
            IOUtils.throwRFE(length, maxLength);
        }
    }

    public static byte[] toByteArray(ByteBuffer buffer, int length) {
        if (buffer.hasArray() && buffer.arrayOffset() == 0) {
            return buffer.array();
        }
        IOUtils.checkByteSizeLimit(length);
        byte[] data = new byte[length];
        buffer.get(data);
        return data;
    }

    public static int readFully(ReadableByteChannel channel, ByteBuffer b) throws IOException {
        int got;
        int total = 0;
        do {
            if ((got = channel.read(b)) >= 0) continue;
            return total == 0 ? -1 : total;
        } while ((total += got) != b.capacity() && b.position() != b.capacity());
        return total;
    }

    public static long copy(InputStream inp, OutputStream out) throws IOException {
        return IOUtils.copy(inp, out, -1L);
    }

    public static long copy(InputStream inp, OutputStream out, long limit) throws IOException {
        byte[] buff = new byte[4096];
        long totalCount = 0L;
        int readBytes = -1;
        do {
            int todoBytes;
            if ((todoBytes = (int)(limit < 0L ? (long)buff.length : Math.min(limit - totalCount, (long)buff.length))) <= 0 || (readBytes = inp.read(buff, 0, todoBytes)) <= 0) continue;
            out.write(buff, 0, readBytes);
            totalCount += (long)readBytes;
        } while (readBytes >= 0 && (limit == -1L || totalCount < limit));
        return totalCount;
    }

    public static long skipFully(InputStream input, long toSkip) throws IOException {
        long remain;
        long n;
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + toSkip);
        }
        if (toSkip == 0L) {
            return 0L;
        }
        if (SKIP_BYTE_BUFFER == null) {
            SKIP_BYTE_BUFFER = new byte[2048];
        }
        for (remain = toSkip; remain > 0L && (n = (long)input.read(SKIP_BYTE_BUFFER, 0, (int)Math.min(remain, 2048L))) >= 0L; remain -= n) {
        }
        if (toSkip == remain) {
            return -1L;
        }
        return toSkip - remain;
    }

    public static byte[] safelyAllocate(long length, int maxLength) {
        IOUtils.safelyAllocateCheck(length, maxLength);
        IOUtils.checkByteSizeLimit((int)length);
        return new byte[(int)length];
    }

    public static void safelyAllocateCheck(long length, int maxLength) {
        if (length < 0L) {
            throw new RecordFormatException("Can't allocate an array of length < 0, but had " + length + " and " + maxLength);
        }
        if (length > Integer.MAX_VALUE) {
            throw new RecordFormatException("Can't allocate an array > 2147483647");
        }
        IOUtils.checkLength(length, maxLength);
    }

    private static void throwRFE(long length, int maxLength) {
        throw new RecordFormatException(String.format(Locale.ROOT, "Tried to allocate an array of length %,d, but the maximum lenght for this record type is %,d.\nIf the file is not corrupt, please open an issue on bugzilla to request \nincreasing the maximum allowable size for this record type.\nAs a temporary workaround, consider setting a higher override value with IOUtils.setByteArrayMaxOverride()", length, maxLength));
    }

    static {
        BYTE_ARRAY_MAX_OVERRIDE = -1;
    }
}

