/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.asn1.x500;

import java.util.Enumeration;
import net.jsign.bouncycastle.asn1.ASN1Choice;
import net.jsign.bouncycastle.asn1.ASN1Encodable;
import net.jsign.bouncycastle.asn1.ASN1Object;
import net.jsign.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.jsign.bouncycastle.asn1.ASN1Primitive;
import net.jsign.bouncycastle.asn1.ASN1Sequence;
import net.jsign.bouncycastle.asn1.ASN1TaggedObject;
import net.jsign.bouncycastle.asn1.DERSequence;
import net.jsign.bouncycastle.asn1.x500.RDN;
import net.jsign.bouncycastle.asn1.x500.X500NameStyle;
import net.jsign.bouncycastle.asn1.x500.style.BCStyle;

public class X500Name
extends ASN1Object
implements ASN1Choice {
    private static X500NameStyle defaultStyle = BCStyle.INSTANCE;
    private boolean isHashCodeCalculated;
    private int hashCodeValue;
    private X500NameStyle style;
    private RDN[] rdns;
    private DERSequence rdnSeq;

    public static X500Name getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return X500Name.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, true));
    }

    public static X500Name getInstance(Object object) {
        if (object instanceof X500Name) {
            return (X500Name)object;
        }
        if (object != null) {
            return new X500Name(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private X500Name(ASN1Sequence aSN1Sequence) {
        this(defaultStyle, aSN1Sequence);
    }

    private X500Name(X500NameStyle x500NameStyle, ASN1Sequence aSN1Sequence) {
        this.style = x500NameStyle;
        this.rdns = new RDN[aSN1Sequence.size()];
        boolean bl = true;
        int n = 0;
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            RDN rDN = RDN.getInstance(e);
            bl &= rDN == e;
            this.rdns[n++] = rDN;
        }
        this.rdnSeq = bl ? DERSequence.convert(aSN1Sequence) : new DERSequence(this.rdns);
    }

    public RDN[] getRDNs() {
        return (RDN[])this.rdns.clone();
    }

    public RDN[] getRDNs(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        RDN[] rDNArray = new RDN[this.rdns.length];
        int n = 0;
        for (int i = 0; i != this.rdns.length; ++i) {
            RDN rDN = this.rdns[i];
            if (!rDN.containsAttributeType(aSN1ObjectIdentifier)) continue;
            rDNArray[n++] = rDN;
        }
        if (n < rDNArray.length) {
            RDN[] rDNArray2 = new RDN[n];
            System.arraycopy(rDNArray, 0, rDNArray2, 0, rDNArray2.length);
            rDNArray = rDNArray2;
        }
        return rDNArray;
    }

    public ASN1Primitive toASN1Primitive() {
        return this.rdnSeq;
    }

    public int hashCode() {
        if (this.isHashCodeCalculated) {
            return this.hashCodeValue;
        }
        this.isHashCodeCalculated = true;
        this.hashCodeValue = this.style.calculateHashCode(this);
        return this.hashCodeValue;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof X500Name) && !(object instanceof ASN1Sequence)) {
            return false;
        }
        ASN1Primitive aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive();
        if (this.toASN1Primitive().equals(aSN1Primitive)) {
            return true;
        }
        try {
            return this.style.areEqual(this, new X500Name(ASN1Sequence.getInstance(((ASN1Encodable)object).toASN1Primitive())));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String toString() {
        return this.style.toString(this);
    }
}

