/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.util;

import java.math.BigInteger;
import java.security.SecureRandom;
import net.jsign.bouncycastle.math.raw.Mod;
import net.jsign.bouncycastle.math.raw.Nat;

public final class BigIntegers {
    public static final BigInteger ZERO = BigInteger.valueOf(0L);
    public static final BigInteger ONE = BigInteger.valueOf(1L);
    public static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger THREE = BigInteger.valueOf(3L);
    private static final BigInteger SMALL_PRIMES_PRODUCT = new BigInteger("8138e8a0fcf3a4e84a771d40fd305d7f4aa59306d7251de54d98af8fe95729a1f73d893fa424cd2edc8636a6c3285e022b0e3866a565ae8108eed8591cd4fe8d2ce86165a978d719ebf647f362d33fca29cd179fb42401cbaf3df0c614056f9c8f3cfd51e474afb6bc6974f78db8aba8e9e517fded658591ab7502bd41849462f", 16);
    private static final int MAX_SMALL = BigInteger.valueOf(743L).bitLength();

    public static BigInteger modOddInverse(BigInteger bigInteger, BigInteger bigInteger2) {
        int n;
        int[] nArray;
        int[] nArray2;
        int n2;
        int[] nArray3;
        if (!bigInteger.testBit(0)) {
            throw new IllegalArgumentException("'M' must be odd");
        }
        if (bigInteger.signum() != 1) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        if (bigInteger2.signum() < 0 || bigInteger2.compareTo(bigInteger) >= 0) {
            bigInteger2 = bigInteger2.mod(bigInteger);
        }
        if (0 == Mod.modOddInverse(nArray3 = Nat.fromBigInteger(n2 = bigInteger.bitLength(), bigInteger), nArray2 = Nat.fromBigInteger(n2, bigInteger2), nArray = Nat.create(n = nArray3.length))) {
            throw new ArithmeticException("BigInteger not invertible.");
        }
        return Nat.toBigInteger(n, nArray);
    }

    public static BigInteger createRandomBigInteger(int n, SecureRandom secureRandom) {
        return new BigInteger(1, BigIntegers.createRandom(n, secureRandom));
    }

    private static byte[] createRandom(int n, SecureRandom secureRandom) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException("bitLength must be at least 1");
        }
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        secureRandom.nextBytes(byArray);
        int n3 = 8 * n2 - n;
        byArray[0] = (byte)(byArray[0] & (byte)(255 >>> n3));
        return byArray;
    }
}

