/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.commons.math3.util;

import net.jsign.commons.math3.exception.MathArithmeticException;

public final class ArithmeticUtils {
    public static int mulAndCheck(int x, int y) throws MathArithmeticException {
        long m = (long)x * (long)y;
        if (m < Integer.MIN_VALUE || m > Integer.MAX_VALUE) {
            throw new MathArithmeticException();
        }
        return (int)m;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long mulAndCheck(long a, long b) throws MathArithmeticException {
        if (a > b) {
            return ArithmeticUtils.mulAndCheck(b, a);
        }
        if (a < 0L) {
            if (b < 0L) {
                if (a < Long.MAX_VALUE / b) throw new MathArithmeticException();
                return a * b;
            }
            if (b <= 0L) return 0L;
            if (Long.MIN_VALUE / b > a) throw new MathArithmeticException();
            return a * b;
        }
        if (a <= 0L) return 0L;
        if (a > Long.MAX_VALUE / b) throw new MathArithmeticException();
        return a * b;
    }
}

