/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.jsign.DigestAlgorithm;
import net.jsign.jca.RESTClient;
import net.jsign.jca.SigningService;
import net.jsign.jca.SigningServicePrivateKey;
import net.jsign.json-io.util.io.JsonWriter;

public class GoogleCloudSigningService
implements SigningService {
    private final String keyring;
    private final Function<String, Certificate[]> certificateStore;
    private final Map<String, SigningServicePrivateKey> keys = new HashMap<String, SigningServicePrivateKey>();
    private final RESTClient client;

    public GoogleCloudSigningService(String keyring, String token, Function<String, Certificate[]> certificateStore) {
        this.keyring = keyring;
        this.certificateStore = certificateStore;
        this.client = new RESTClient("https://cloudkms.googleapis.com/v1/", conn -> conn.setRequestProperty("Authorization", "Bearer " + token));
    }

    @Override
    public String getName() {
        return "GoogleCloud";
    }

    @Override
    public List<String> aliases() throws KeyStoreException {
        ArrayList<String> aliases = new ArrayList<String>();
        try {
            Object[] cryptoKeys;
            Map<String, ?> response = this.client.get(this.keyring + "/cryptoKeys");
            for (Object cryptoKey : cryptoKeys = (Object[])response.get("cryptoKeys")) {
                String name = (String)((Map)cryptoKey).get("name");
                aliases.add(name.substring(name.lastIndexOf("/") + 1));
            }
        }
        catch (IOException e) {
            throw new KeyStoreException(e);
        }
        return aliases;
    }

    @Override
    public Certificate[] getCertificateChain(String alias) {
        return this.certificateStore.apply(alias);
    }

    @Override
    public SigningServicePrivateKey getPrivateKey(String alias) throws UnrecoverableKeyException {
        String algorithm;
        if (!alias.startsWith("projects/")) {
            alias = this.keyring + "/cryptoKeys/" + alias;
        }
        if (this.keys.containsKey(alias)) {
            return this.keys.get(alias);
        }
        try {
            Map<String, ?> response;
            if (alias.contains("cryptoKeyVersions")) {
                if (alias.contains(":")) {
                    algorithm = alias.substring(alias.indexOf(58) + 1) + "_SIGN";
                    alias = alias.substring(0, alias.indexOf(58));
                } else {
                    response = this.client.get(alias);
                    algorithm = (String)response.get("algorithm");
                }
            } else {
                response = this.client.get(alias + "/cryptoKeyVersions?filter=state%3DENABLED");
                Object[] cryptoKeyVersions = (Object[])response.get("cryptoKeyVersions");
                if (cryptoKeyVersions == null || cryptoKeyVersions.length == 0) {
                    throw new UnrecoverableKeyException("Unable to fetch Google Cloud private key '" + alias + "', no version found");
                }
                Map cryptoKeyVersion = (Map)cryptoKeyVersions[cryptoKeyVersions.length - 1];
                alias = (String)cryptoKeyVersion.get("name");
                algorithm = (String)cryptoKeyVersion.get("algorithm");
            }
        }
        catch (IOException e) {
            throw (UnrecoverableKeyException)new UnrecoverableKeyException("Unable to fetch Google Cloud private key '" + alias + "'").initCause(e);
        }
        algorithm = algorithm.substring(0, algorithm.indexOf("_"));
        SigningServicePrivateKey key = new SigningServicePrivateKey(alias, algorithm);
        this.keys.put(alias, key);
        return key;
    }

    @Override
    public byte[] sign(SigningServicePrivateKey privateKey, String algorithm, byte[] data) throws GeneralSecurityException {
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.of(algorithm.substring(0, algorithm.toLowerCase().indexOf("with")));
        data = digestAlgorithm.getMessageDigest().digest(data);
        HashMap<String, String> digest = new HashMap<String, String>();
        digest.put(digestAlgorithm.name().toLowerCase(), Base64.getEncoder().encodeToString(data));
        HashMap<String, HashMap<String, String>> request = new HashMap<String, HashMap<String, String>>();
        request.put("digest", digest);
        try {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("TYPE", "false");
            Map<String, ?> response = this.client.post(privateKey.getId() + ":asymmetricSign", JsonWriter.objectToJson(request, args));
            String signature = (String)response.get("signature");
            return Base64.getDecoder().decode(signature);
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }
}

