/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.pe;

import java.nio.charset.StandardCharsets;
import java.util.List;
import net.jsign.pe.PEFile;
import net.jsign.pe.SectionFlag;

public class Section {
    private final PEFile peFile;
    final int baseOffset;

    Section(PEFile peFile, int baseOffset) {
        this.peFile = peFile;
        this.baseOffset = baseOffset;
    }

    public String getName() {
        byte[] buffer = new byte[8];
        this.peFile.read(buffer, (long)this.baseOffset, 0);
        String name = new String(buffer, StandardCharsets.UTF_8);
        if (name.indexOf(0) != -1) {
            name = name.substring(0, name.indexOf(0));
        }
        return name;
    }

    public long getVirtualSize() {
        return this.peFile.readDWord(this.baseOffset, 8);
    }

    public long getVirtualAddress() {
        return this.peFile.readDWord(this.baseOffset, 12);
    }

    public long getSizeOfRawData() {
        return this.peFile.readDWord(this.baseOffset, 16);
    }

    public long getPointerToRawData() {
        return this.peFile.readDWord(this.baseOffset, 20);
    }

    public long getPointerToRelocations() {
        return this.peFile.readDWord(this.baseOffset, 24);
    }

    public long getPointerToLineNumbers() {
        return this.peFile.readDWord(this.baseOffset, 28);
    }

    public int getNumberOfRelocations() {
        return this.peFile.readWord(this.baseOffset, 32);
    }

    public int getNumberOfLineNumbers() {
        return this.peFile.readWord(this.baseOffset, 34);
    }

    public List<SectionFlag> getCharacteristics() {
        return SectionFlag.getFlags((int)this.peFile.readDWord(this.baseOffset, 36));
    }
}

