/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;

class ProviderUtils {
    static Provider createSunPKCS11Provider(String configuration) {
        try {
            try {
                Method providerConfigureMethod = Provider.class.getMethod("configure", String.class);
                Provider provider = Security.getProvider("SunPKCS11");
                if (provider == null) {
                    throw new ProviderException("SunPKCS11 provider not found, check the java.security file");
                }
                return (Provider)providerConfigureMethod.invoke((Object)provider, configuration);
            }
            catch (NoSuchMethodException e) {
                Constructor<?> sunpkcs11Constructor = Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(String.class);
                return (Provider)sunpkcs11Constructor.newInstance(configuration);
            }
        }
        catch (Exception e) {
            throw new ProviderException("Failed to create a SunPKCS11 provider from the configuration " + configuration, e);
        }
    }
}

