/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.openssl.jcajce;

import java.security.Provider;
import net.jsign.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.jsign.bouncycastle.jcajce.util.JcaJceHelper;
import net.jsign.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.jsign.bouncycastle.openssl.PEMDecryptor;
import net.jsign.bouncycastle.openssl.PEMDecryptorProvider;
import net.jsign.bouncycastle.openssl.PEMException;
import net.jsign.bouncycastle.openssl.PasswordException;
import net.jsign.bouncycastle.openssl.jcajce.PEMUtilities;

public class JcePEMDecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcePEMDecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public PEMDecryptorProvider build(final char[] cArray) {
        return new PEMDecryptorProvider(){

            @Override
            public PEMDecryptor get(final String string) {
                return new PEMDecryptor(){

                    @Override
                    public byte[] decrypt(byte[] byArray, byte[] byArray2) throws PEMException {
                        if (cArray == null) {
                            throw new PasswordException("Password is null, but a password is required");
                        }
                        return PEMUtilities.crypt(false, JcePEMDecryptorProviderBuilder.this.helper, byArray, cArray, string, byArray2);
                    }
                };
            }
        };
    }
}

