/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.pkcs;

import java.io.ByteArrayInputStream;
import net.jsign.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import net.jsign.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.jsign.bouncycastle.operator.InputDecryptor;
import net.jsign.bouncycastle.operator.InputDecryptorProvider;
import net.jsign.bouncycastle.pkcs.PKCSException;
import net.jsign.bouncycastle.util.io.Streams;

public class PKCS8EncryptedPrivateKeyInfo {
    private EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;

    public PKCS8EncryptedPrivateKeyInfo(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo) {
        this.encryptedPrivateKeyInfo = encryptedPrivateKeyInfo;
    }

    public PrivateKeyInfo decryptPrivateKeyInfo(InputDecryptorProvider inputDecryptorProvider) throws PKCSException {
        try {
            InputDecryptor inputDecryptor = inputDecryptorProvider.get(this.encryptedPrivateKeyInfo.getEncryptionAlgorithm());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.encryptedPrivateKeyInfo.getEncryptedData());
            return PrivateKeyInfo.getInstance(Streams.readAll(inputDecryptor.getInputStream(byteArrayInputStream)));
        }
        catch (Exception exception) {
            throw new PKCSException("unable to read encrypted data: " + exception.getMessage(), exception);
        }
    }
}

